/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.AppMonitorDetails;
import software.amazon.awssdk.services.rum.model.RumEvent;
import software.amazon.awssdk.services.rum.model.RumEventListCopier;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.services.rum.model.UserDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRumEventsRequest
extends RumRequest
implements ToCopyableBuilder<Builder, PutRumEventsRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(PutRumEventsRequest.getter(PutRumEventsRequest::alias)).setter(PutRumEventsRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<AppMonitorDetails> APP_MONITOR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppMonitorDetails").getter(PutRumEventsRequest.getter(PutRumEventsRequest::appMonitorDetails)).setter(PutRumEventsRequest.setter(Builder::appMonitorDetails)).constructor(AppMonitorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorDetails").build()}).build();
    private static final SdkField<String> BATCH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchId").getter(PutRumEventsRequest.getter(PutRumEventsRequest::batchId)).setter(PutRumEventsRequest.setter(Builder::batchId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(PutRumEventsRequest.getter(PutRumEventsRequest::id)).setter(PutRumEventsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<List<RumEvent>> RUM_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RumEvents").getter(PutRumEventsRequest.getter(PutRumEventsRequest::rumEvents)).setter(PutRumEventsRequest.setter(Builder::rumEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RumEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RumEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UserDetails> USER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserDetails").getter(PutRumEventsRequest.getter(PutRumEventsRequest::userDetails)).setter(PutRumEventsRequest.setter(Builder::userDetails)).constructor(UserDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, APP_MONITOR_DETAILS_FIELD, BATCH_ID_FIELD, ID_FIELD, RUM_EVENTS_FIELD, USER_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRumEventsRequest.memberNameToFieldInitializer();
    private final String alias;
    private final AppMonitorDetails appMonitorDetails;
    private final String batchId;
    private final String id;
    private final List<RumEvent> rumEvents;
    private final UserDetails userDetails;

    private PutRumEventsRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.appMonitorDetails = builder.appMonitorDetails;
        this.batchId = builder.batchId;
        this.id = builder.id;
        this.rumEvents = builder.rumEvents;
        this.userDetails = builder.userDetails;
    }

    public final String alias() {
        return this.alias;
    }

    public final AppMonitorDetails appMonitorDetails() {
        return this.appMonitorDetails;
    }

    public final String batchId() {
        return this.batchId;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasRumEvents() {
        return this.rumEvents != null && !(this.rumEvents instanceof SdkAutoConstructList);
    }

    public final List<RumEvent> rumEvents() {
        return this.rumEvents;
    }

    public final UserDetails userDetails() {
        return this.userDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRumEvents() ? this.rumEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRumEventsRequest)) {
            return false;
        }
        PutRumEventsRequest other = (PutRumEventsRequest)((Object)obj);
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.appMonitorDetails(), other.appMonitorDetails()) && Objects.equals(this.batchId(), other.batchId()) && Objects.equals(this.id(), other.id()) && this.hasRumEvents() == other.hasRumEvents() && Objects.equals(this.rumEvents(), other.rumEvents()) && Objects.equals(this.userDetails(), other.userDetails());
    }

    public final String toString() {
        return ToString.builder((String)"PutRumEventsRequest").add("Alias", (Object)this.alias()).add("AppMonitorDetails", (Object)this.appMonitorDetails()).add("BatchId", (Object)this.batchId()).add("Id", (Object)this.id()).add("RumEvents", this.hasRumEvents() ? this.rumEvents() : null).add("UserDetails", (Object)this.userDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "AppMonitorDetails": {
                return Optional.ofNullable(clazz.cast(this.appMonitorDetails()));
            }
            case "BatchId": {
                return Optional.ofNullable(clazz.cast(this.batchId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "RumEvents": {
                return Optional.ofNullable(clazz.cast(this.rumEvents()));
            }
            case "UserDetails": {
                return Optional.ofNullable(clazz.cast(this.userDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("AppMonitorDetails", APP_MONITOR_DETAILS_FIELD);
        map.put("BatchId", BATCH_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("RumEvents", RUM_EVENTS_FIELD);
        map.put("UserDetails", USER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRumEventsRequest, T> g) {
        return obj -> g.apply((PutRumEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String alias;
        private AppMonitorDetails appMonitorDetails;
        private String batchId;
        private String id;
        private List<RumEvent> rumEvents = DefaultSdkAutoConstructList.getInstance();
        private UserDetails userDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRumEventsRequest model) {
            super(model);
            this.alias(model.alias);
            this.appMonitorDetails(model.appMonitorDetails);
            this.batchId(model.batchId);
            this.id(model.id);
            this.rumEvents(model.rumEvents);
            this.userDetails(model.userDetails);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final AppMonitorDetails.Builder getAppMonitorDetails() {
            return this.appMonitorDetails != null ? this.appMonitorDetails.toBuilder() : null;
        }

        public final void setAppMonitorDetails(AppMonitorDetails.BuilderImpl appMonitorDetails) {
            this.appMonitorDetails = appMonitorDetails != null ? appMonitorDetails.build() : null;
        }

        @Override
        public final Builder appMonitorDetails(AppMonitorDetails appMonitorDetails) {
            this.appMonitorDetails = appMonitorDetails;
            return this;
        }

        public final String getBatchId() {
            return this.batchId;
        }

        public final void setBatchId(String batchId) {
            this.batchId = batchId;
        }

        @Override
        public final Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<RumEvent.Builder> getRumEvents() {
            List<RumEvent.Builder> result = RumEventListCopier.copyToBuilder(this.rumEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRumEvents(Collection<RumEvent.BuilderImpl> rumEvents) {
            this.rumEvents = RumEventListCopier.copyFromBuilder(rumEvents);
        }

        @Override
        public final Builder rumEvents(Collection<RumEvent> rumEvents) {
            this.rumEvents = RumEventListCopier.copy(rumEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rumEvents(RumEvent ... rumEvents) {
            this.rumEvents(Arrays.asList(rumEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rumEvents(Consumer<RumEvent.Builder> ... rumEvents) {
            this.rumEvents(Stream.of(rumEvents).map(c -> (RumEvent)((RumEvent.Builder)RumEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final UserDetails.Builder getUserDetails() {
            return this.userDetails != null ? this.userDetails.toBuilder() : null;
        }

        public final void setUserDetails(UserDetails.BuilderImpl userDetails) {
            this.userDetails = userDetails != null ? userDetails.build() : null;
        }

        @Override
        public final Builder userDetails(UserDetails userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRumEventsRequest build() {
            return new PutRumEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRumEventsRequest> {
        public Builder alias(String var1);

        public Builder appMonitorDetails(AppMonitorDetails var1);

        default public Builder appMonitorDetails(Consumer<AppMonitorDetails.Builder> appMonitorDetails) {
            return this.appMonitorDetails((AppMonitorDetails)((AppMonitorDetails.Builder)AppMonitorDetails.builder().applyMutation(appMonitorDetails)).build());
        }

        public Builder batchId(String var1);

        public Builder id(String var1);

        public Builder rumEvents(Collection<RumEvent> var1);

        public Builder rumEvents(RumEvent ... var1);

        public Builder rumEvents(Consumer<RumEvent.Builder> ... var1);

        public Builder userDetails(UserDetails var1);

        default public Builder userDetails(Consumer<UserDetails.Builder> userDetails) {
            return this.userDetails((UserDetails)((UserDetails.Builder)UserDetails.builder().applyMutation(userDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

