/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricDestination {
    CLOUD_WATCH("CloudWatch"),
    EVIDENTLY("Evidently"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricDestination> VALUE_MAP;
    private final String value;

    private MetricDestination(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricDestination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricDestination> knownValues() {
        EnumSet<MetricDestination> knownValues = EnumSet.allOf(MetricDestination.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricDestination.class, MetricDestination::toString);
    }
}

