/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumClient;
import software.amazon.awssdk.services.rum.internal.UserAgentUtils;
import software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest;
import software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse;
import software.amazon.awssdk.services.rum.model.MetricDefinition;

public class BatchGetRumMetricDefinitionsIterable
implements SdkIterable<BatchGetRumMetricDefinitionsResponse> {
    private final RumClient client;
    private final BatchGetRumMetricDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetRumMetricDefinitionsIterable(RumClient client, BatchGetRumMetricDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new BatchGetRumMetricDefinitionsResponseFetcher();
    }

    public Iterator<BatchGetRumMetricDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricDefinition> metricDefinitions() {
        Function<BatchGetRumMetricDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDefinitions() != null) {
                return response.metricDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class BatchGetRumMetricDefinitionsResponseFetcher
    implements SyncPageFetcher<BatchGetRumMetricDefinitionsResponse> {
        private BatchGetRumMetricDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetRumMetricDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetRumMetricDefinitionsResponse nextPage(BatchGetRumMetricDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return BatchGetRumMetricDefinitionsIterable.this.client.batchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsIterable.this.firstRequest);
            }
            return BatchGetRumMetricDefinitionsIterable.this.client.batchGetRumMetricDefinitions((BatchGetRumMetricDefinitionsRequest)((Object)BatchGetRumMetricDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

