/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Telemetry {
    ERRORS("errors"),
    PERFORMANCE("performance"),
    HTTP("http"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Telemetry> VALUE_MAP;
    private final String value;

    private Telemetry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Telemetry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Telemetry> knownValues() {
        EnumSet<Telemetry> knownValues = EnumSet.allOf(Telemetry.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Telemetry.class, Telemetry::toString);
    }
}

