/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.FavoritePagesCopier;
import software.amazon.awssdk.services.rum.model.PagesCopier;
import software.amazon.awssdk.services.rum.model.TelemetriesCopier;
import software.amazon.awssdk.services.rum.model.Telemetry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppMonitorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppMonitorConfiguration> {
    private static final SdkField<Boolean> ALLOW_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCookies").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::allowCookies)).setter(AppMonitorConfiguration.setter(Builder::allowCookies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCookies").build()}).build();
    private static final SdkField<Boolean> ENABLE_X_RAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableXRay").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::enableXRay)).setter(AppMonitorConfiguration.setter(Builder::enableXRay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableXRay").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedPages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::excludedPages)).setter(AppMonitorConfiguration.setter(Builder::excludedPages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedPages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAVORITE_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FavoritePages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::favoritePages)).setter(AppMonitorConfiguration.setter(Builder::favoritePages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FavoritePages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GUEST_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GuestRoleArn").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::guestRoleArn)).setter(AppMonitorConfiguration.setter(Builder::guestRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuestRoleArn").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::identityPoolId)).setter(AppMonitorConfiguration.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<List<String>> INCLUDED_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedPages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::includedPages)).setter(AppMonitorConfiguration.setter(Builder::includedPages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedPages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SESSION_SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SessionSampleRate").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::sessionSampleRate)).setter(AppMonitorConfiguration.setter(Builder::sessionSampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionSampleRate").build()}).build();
    private static final SdkField<List<String>> TELEMETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Telemetries").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::telemetriesAsStrings)).setter(AppMonitorConfiguration.setter(Builder::telemetriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telemetries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_COOKIES_FIELD, ENABLE_X_RAY_FIELD, EXCLUDED_PAGES_FIELD, FAVORITE_PAGES_FIELD, GUEST_ROLE_ARN_FIELD, IDENTITY_POOL_ID_FIELD, INCLUDED_PAGES_FIELD, SESSION_SAMPLE_RATE_FIELD, TELEMETRIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allowCookies;
    private final Boolean enableXRay;
    private final List<String> excludedPages;
    private final List<String> favoritePages;
    private final String guestRoleArn;
    private final String identityPoolId;
    private final List<String> includedPages;
    private final Double sessionSampleRate;
    private final List<String> telemetries;

    private AppMonitorConfiguration(BuilderImpl builder) {
        this.allowCookies = builder.allowCookies;
        this.enableXRay = builder.enableXRay;
        this.excludedPages = builder.excludedPages;
        this.favoritePages = builder.favoritePages;
        this.guestRoleArn = builder.guestRoleArn;
        this.identityPoolId = builder.identityPoolId;
        this.includedPages = builder.includedPages;
        this.sessionSampleRate = builder.sessionSampleRate;
        this.telemetries = builder.telemetries;
    }

    public final Boolean allowCookies() {
        return this.allowCookies;
    }

    public final Boolean enableXRay() {
        return this.enableXRay;
    }

    public final boolean hasExcludedPages() {
        return this.excludedPages != null && !(this.excludedPages instanceof SdkAutoConstructList);
    }

    public final List<String> excludedPages() {
        return this.excludedPages;
    }

    public final boolean hasFavoritePages() {
        return this.favoritePages != null && !(this.favoritePages instanceof SdkAutoConstructList);
    }

    public final List<String> favoritePages() {
        return this.favoritePages;
    }

    public final String guestRoleArn() {
        return this.guestRoleArn;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final boolean hasIncludedPages() {
        return this.includedPages != null && !(this.includedPages instanceof SdkAutoConstructList);
    }

    public final List<String> includedPages() {
        return this.includedPages;
    }

    public final Double sessionSampleRate() {
        return this.sessionSampleRate;
    }

    public final List<Telemetry> telemetries() {
        return TelemetriesCopier.copyStringToEnum(this.telemetries);
    }

    public final boolean hasTelemetries() {
        return this.telemetries != null && !(this.telemetries instanceof SdkAutoConstructList);
    }

    public final List<String> telemetriesAsStrings() {
        return this.telemetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCookies());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableXRay());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedPages() ? this.excludedPages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFavoritePages() ? this.favoritePages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guestRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedPages() ? this.includedPages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionSampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetries() ? this.telemetriesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitorConfiguration)) {
            return false;
        }
        AppMonitorConfiguration other = (AppMonitorConfiguration)obj;
        return Objects.equals(this.allowCookies(), other.allowCookies()) && Objects.equals(this.enableXRay(), other.enableXRay()) && this.hasExcludedPages() == other.hasExcludedPages() && Objects.equals(this.excludedPages(), other.excludedPages()) && this.hasFavoritePages() == other.hasFavoritePages() && Objects.equals(this.favoritePages(), other.favoritePages()) && Objects.equals(this.guestRoleArn(), other.guestRoleArn()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && this.hasIncludedPages() == other.hasIncludedPages() && Objects.equals(this.includedPages(), other.includedPages()) && Objects.equals(this.sessionSampleRate(), other.sessionSampleRate()) && this.hasTelemetries() == other.hasTelemetries() && Objects.equals(this.telemetriesAsStrings(), other.telemetriesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AppMonitorConfiguration").add("AllowCookies", (Object)this.allowCookies()).add("EnableXRay", (Object)this.enableXRay()).add("ExcludedPages", this.hasExcludedPages() ? this.excludedPages() : null).add("FavoritePages", this.hasFavoritePages() ? this.favoritePages() : null).add("GuestRoleArn", (Object)this.guestRoleArn()).add("IdentityPoolId", (Object)this.identityPoolId()).add("IncludedPages", this.hasIncludedPages() ? this.includedPages() : null).add("SessionSampleRate", (Object)this.sessionSampleRate()).add("Telemetries", this.hasTelemetries() ? this.telemetriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowCookies": {
                return Optional.ofNullable(clazz.cast(this.allowCookies()));
            }
            case "EnableXRay": {
                return Optional.ofNullable(clazz.cast(this.enableXRay()));
            }
            case "ExcludedPages": {
                return Optional.ofNullable(clazz.cast(this.excludedPages()));
            }
            case "FavoritePages": {
                return Optional.ofNullable(clazz.cast(this.favoritePages()));
            }
            case "GuestRoleArn": {
                return Optional.ofNullable(clazz.cast(this.guestRoleArn()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IncludedPages": {
                return Optional.ofNullable(clazz.cast(this.includedPages()));
            }
            case "SessionSampleRate": {
                return Optional.ofNullable(clazz.cast(this.sessionSampleRate()));
            }
            case "Telemetries": {
                return Optional.ofNullable(clazz.cast(this.telemetriesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppMonitorConfiguration, T> g) {
        return obj -> g.apply((AppMonitorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowCookies;
        private Boolean enableXRay;
        private List<String> excludedPages = DefaultSdkAutoConstructList.getInstance();
        private List<String> favoritePages = DefaultSdkAutoConstructList.getInstance();
        private String guestRoleArn;
        private String identityPoolId;
        private List<String> includedPages = DefaultSdkAutoConstructList.getInstance();
        private Double sessionSampleRate;
        private List<String> telemetries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppMonitorConfiguration model) {
            this.allowCookies(model.allowCookies);
            this.enableXRay(model.enableXRay);
            this.excludedPages(model.excludedPages);
            this.favoritePages(model.favoritePages);
            this.guestRoleArn(model.guestRoleArn);
            this.identityPoolId(model.identityPoolId);
            this.includedPages(model.includedPages);
            this.sessionSampleRate(model.sessionSampleRate);
            this.telemetriesWithStrings(model.telemetries);
        }

        public final Boolean getAllowCookies() {
            return this.allowCookies;
        }

        public final void setAllowCookies(Boolean allowCookies) {
            this.allowCookies = allowCookies;
        }

        @Override
        @Transient
        public final Builder allowCookies(Boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        public final Boolean getEnableXRay() {
            return this.enableXRay;
        }

        public final void setEnableXRay(Boolean enableXRay) {
            this.enableXRay = enableXRay;
        }

        @Override
        @Transient
        public final Builder enableXRay(Boolean enableXRay) {
            this.enableXRay = enableXRay;
            return this;
        }

        public final Collection<String> getExcludedPages() {
            if (this.excludedPages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedPages;
        }

        public final void setExcludedPages(Collection<String> excludedPages) {
            this.excludedPages = PagesCopier.copy(excludedPages);
        }

        @Override
        @Transient
        public final Builder excludedPages(Collection<String> excludedPages) {
            this.excludedPages = PagesCopier.copy(excludedPages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludedPages(String ... excludedPages) {
            this.excludedPages(Arrays.asList(excludedPages));
            return this;
        }

        public final Collection<String> getFavoritePages() {
            if (this.favoritePages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.favoritePages;
        }

        public final void setFavoritePages(Collection<String> favoritePages) {
            this.favoritePages = FavoritePagesCopier.copy(favoritePages);
        }

        @Override
        @Transient
        public final Builder favoritePages(Collection<String> favoritePages) {
            this.favoritePages = FavoritePagesCopier.copy(favoritePages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder favoritePages(String ... favoritePages) {
            this.favoritePages(Arrays.asList(favoritePages));
            return this;
        }

        public final String getGuestRoleArn() {
            return this.guestRoleArn;
        }

        public final void setGuestRoleArn(String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
        }

        @Override
        @Transient
        public final Builder guestRoleArn(String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
            return this;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Collection<String> getIncludedPages() {
            if (this.includedPages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedPages;
        }

        public final void setIncludedPages(Collection<String> includedPages) {
            this.includedPages = PagesCopier.copy(includedPages);
        }

        @Override
        @Transient
        public final Builder includedPages(Collection<String> includedPages) {
            this.includedPages = PagesCopier.copy(includedPages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includedPages(String ... includedPages) {
            this.includedPages(Arrays.asList(includedPages));
            return this;
        }

        public final Double getSessionSampleRate() {
            return this.sessionSampleRate;
        }

        public final void setSessionSampleRate(Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
        }

        @Override
        @Transient
        public final Builder sessionSampleRate(Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
            return this;
        }

        public final Collection<String> getTelemetries() {
            if (this.telemetries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.telemetries;
        }

        public final void setTelemetries(Collection<String> telemetries) {
            this.telemetries = TelemetriesCopier.copy(telemetries);
        }

        @Override
        @Transient
        public final Builder telemetriesWithStrings(Collection<String> telemetries) {
            this.telemetries = TelemetriesCopier.copy(telemetries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder telemetriesWithStrings(String ... telemetries) {
            this.telemetriesWithStrings(Arrays.asList(telemetries));
            return this;
        }

        @Override
        @Transient
        public final Builder telemetries(Collection<Telemetry> telemetries) {
            this.telemetries = TelemetriesCopier.copyEnumToString(telemetries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder telemetries(Telemetry ... telemetries) {
            this.telemetries(Arrays.asList(telemetries));
            return this;
        }

        public AppMonitorConfiguration build() {
            return new AppMonitorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppMonitorConfiguration> {
        public Builder allowCookies(Boolean var1);

        public Builder enableXRay(Boolean var1);

        public Builder excludedPages(Collection<String> var1);

        public Builder excludedPages(String ... var1);

        public Builder favoritePages(Collection<String> var1);

        public Builder favoritePages(String ... var1);

        public Builder guestRoleArn(String var1);

        public Builder identityPoolId(String var1);

        public Builder includedPages(Collection<String> var1);

        public Builder includedPages(String ... var1);

        public Builder sessionSampleRate(Double var1);

        public Builder telemetriesWithStrings(Collection<String> var1);

        public Builder telemetriesWithStrings(String ... var1);

        public Builder telemetries(Collection<Telemetry> var1);

        public Builder telemetries(Telemetry ... var1);
    }
}

