/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainUpdateOperation;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainsCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFirewallDomainsRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateFirewallDomainsRequest> {
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallDomainListId").getter(UpdateFirewallDomainsRequest.getter(UpdateFirewallDomainsRequest::firewallDomainListId)).setter(UpdateFirewallDomainsRequest.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(UpdateFirewallDomainsRequest.getter(UpdateFirewallDomainsRequest::operationAsString)).setter(UpdateFirewallDomainsRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(UpdateFirewallDomainsRequest.getter(UpdateFirewallDomainsRequest::domains)).setter(UpdateFirewallDomainsRequest.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_DOMAIN_LIST_ID_FIELD, OPERATION_FIELD, DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFirewallDomainsRequest.memberNameToFieldInitializer();
    private final String firewallDomainListId;
    private final String operation;
    private final List<String> domains;

    private UpdateFirewallDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallDomainListId = builder.firewallDomainListId;
        this.operation = builder.operation;
        this.domains = builder.domains;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final FirewallDomainUpdateOperation operation() {
        return FirewallDomainUpdateOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<String> domains() {
        return this.domains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallDomainsRequest)) {
            return false;
        }
        UpdateFirewallDomainsRequest other = (UpdateFirewallDomainsRequest)((Object)obj);
        return Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.operationAsString(), other.operationAsString()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFirewallDomainsRequest").add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Operation", (Object)this.operationAsString()).add("Domains", this.hasDomains() ? this.domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallDomainsRequest, T> g) {
        return obj -> g.apply((UpdateFirewallDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String firewallDomainListId;
        private String operation;
        private List<String> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallDomainsRequest model) {
            super(model);
            this.firewallDomainListId(model.firewallDomainListId);
            this.operation(model.operation);
            this.domains(model.domains);
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FirewallDomainUpdateOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Collection<String> getDomains() {
            if (this.domains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domains;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallDomainsRequest build() {
            return new UpdateFirewallDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFirewallDomainsRequest> {
        public Builder firewallDomainListId(String var1);

        public Builder operation(String var1);

        public Builder operation(FirewallDomainUpdateOperation var1);

        public Builder domains(Collection<String> var1);

        public Builder domains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

