/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfResourceSetOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceSetsResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, ListResourceSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceSetsResponse.getter(ListResourceSetsResponse::nextToken)).setter(ListResourceSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourceSetOutput>> RESOURCE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSets").getter(ListResourceSetsResponse.getter(ListResourceSetsResponse::resourceSets)).setter(ListResourceSetsResponse.setter(Builder::resourceSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSetOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceSetsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ResourceSetOutput> resourceSets;

    private ListResourceSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceSets = builder.resourceSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResourceSets() {
        return this.resourceSets != null && !(this.resourceSets instanceof SdkAutoConstructList);
    }

    public final List<ResourceSetOutput> resourceSets() {
        return this.resourceSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSets() ? this.resourceSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSetsResponse)) {
            return false;
        }
        ListResourceSetsResponse other = (ListResourceSetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourceSets() == other.hasResourceSets() && Objects.equals(this.resourceSets(), other.resourceSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceSetsResponse").add("NextToken", (Object)this.nextToken()).add("ResourceSets", this.hasResourceSets() ? this.resourceSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResourceSets": {
                return Optional.ofNullable(clazz.cast(this.resourceSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceSets", RESOURCE_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSetsResponse, T> g) {
        return obj -> g.apply((ListResourceSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourceSetOutput> resourceSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourceSets(model.resourceSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceSetOutput.Builder> getResourceSets() {
            List<ResourceSetOutput.Builder> result = ___listOfResourceSetOutputCopier.copyToBuilder(this.resourceSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSets(Collection<ResourceSetOutput.BuilderImpl> resourceSets) {
            this.resourceSets = ___listOfResourceSetOutputCopier.copyFromBuilder(resourceSets);
        }

        @Override
        public final Builder resourceSets(Collection<ResourceSetOutput> resourceSets) {
            this.resourceSets = ___listOfResourceSetOutputCopier.copy(resourceSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSets(ResourceSetOutput ... resourceSets) {
            this.resourceSets(Arrays.asList(resourceSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSets(Consumer<ResourceSetOutput.Builder> ... resourceSets) {
            this.resourceSets(Stream.of(resourceSets).map(c -> (ResourceSetOutput)((ResourceSetOutput.Builder)ResourceSetOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResourceSetsResponse build() {
            return new ListResourceSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceSetsResponse> {
        public Builder nextToken(String var1);

        public Builder resourceSets(Collection<ResourceSetOutput> var1);

        public Builder resourceSets(ResourceSetOutput ... var1);

        public Builder resourceSets(Consumer<ResourceSetOutput.Builder> ... var1);
    }
}

