/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CellOutput;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse;

public class ListCellsPublisher
implements SdkPublisher<ListCellsResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final ListCellsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCellsPublisher(Route53RecoveryReadinessAsyncClient client, ListCellsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCellsPublisher(Route53RecoveryReadinessAsyncClient client, ListCellsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCellsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCellsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CellOutput> cells() {
        Function<ListCellsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cells() != null) {
                return response.cells().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCellsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCellsResponseFetcher
    implements AsyncPageFetcher<ListCellsResponse> {
        private ListCellsResponseFetcher() {
        }

        public boolean hasNextPage(ListCellsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCellsResponse> nextPage(ListCellsResponse previousPage) {
            if (previousPage == null) {
                return ListCellsPublisher.this.client.listCells(ListCellsPublisher.this.firstRequest);
            }
            return ListCellsPublisher.this.client.listCells((ListCellsRequest)((Object)ListCellsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

