/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CellOutput;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfCellOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCellsResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, ListCellsResponse> {
    private static final SdkField<List<CellOutput>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cells").getter(ListCellsResponse.getter(ListCellsResponse::cells)).setter(ListCellsResponse.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CellOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCellsResponse.getter(ListCellsResponse::nextToken)).setter(ListCellsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCellsResponse.memberNameToFieldInitializer();
    private final List<CellOutput> cells;
    private final String nextToken;

    private ListCellsResponse(BuilderImpl builder) {
        super(builder);
        this.cells = builder.cells;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<CellOutput> cells() {
        return this.cells;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCellsResponse)) {
            return false;
        }
        ListCellsResponse other = (ListCellsResponse)((Object)obj);
        return this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCellsResponse").add("Cells", this.hasCells() ? this.cells() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cells", CELLS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCellsResponse, T> g) {
        return obj -> g.apply((ListCellsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private List<CellOutput> cells = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCellsResponse model) {
            super(model);
            this.cells(model.cells);
            this.nextToken(model.nextToken);
        }

        public final List<CellOutput.Builder> getCells() {
            List<CellOutput.Builder> result = ___listOfCellOutputCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCells(Collection<CellOutput.BuilderImpl> cells) {
            this.cells = ___listOfCellOutputCopier.copyFromBuilder(cells);
        }

        @Override
        public final Builder cells(Collection<CellOutput> cells) {
            this.cells = ___listOfCellOutputCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(CellOutput ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<CellOutput.Builder> ... cells) {
            this.cells(Stream.of(cells).map(c -> (CellOutput)((CellOutput.Builder)CellOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCellsResponse build() {
            return new ListCellsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCellsResponse> {
        public Builder cells(Collection<CellOutput> var1);

        public Builder cells(CellOutput ... var1);

        public Builder cells(Consumer<CellOutput.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

