/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DNSTargetResource;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(Resource.getter(Resource::componentId)).setter(Resource.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()}).build();
    private static final SdkField<DNSTargetResource> DNS_TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsTargetResource").getter(Resource.getter(Resource::dnsTargetResource)).setter(Resource.setter(Builder::dnsTargetResource)).constructor(DNSTargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsTargetResource").build()}).build();
    private static final SdkField<List<String>> READINESS_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadinessScopes").getter(Resource.getter(Resource::readinessScopes)).setter(Resource.setter(Builder::readinessScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Resource.getter(Resource::resourceArn)).setter(Resource.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD, DNS_TARGET_RESOURCE_FIELD, READINESS_SCOPES_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentId;
    private final DNSTargetResource dnsTargetResource;
    private final List<String> readinessScopes;
    private final String resourceArn;

    private Resource(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.dnsTargetResource = builder.dnsTargetResource;
        this.readinessScopes = builder.readinessScopes;
        this.resourceArn = builder.resourceArn;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final DNSTargetResource dnsTargetResource() {
        return this.dnsTargetResource;
    }

    public final boolean hasReadinessScopes() {
        return this.readinessScopes != null && !(this.readinessScopes instanceof SdkAutoConstructList);
    }

    public final List<String> readinessScopes() {
        return this.readinessScopes;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsTargetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadinessScopes() ? this.readinessScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.dnsTargetResource(), other.dnsTargetResource()) && this.hasReadinessScopes() == other.hasReadinessScopes() && Objects.equals(this.readinessScopes(), other.readinessScopes()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("ComponentId", (Object)this.componentId()).add("DnsTargetResource", (Object)this.dnsTargetResource()).add("ReadinessScopes", this.hasReadinessScopes() ? this.readinessScopes() : null).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "DnsTargetResource": {
                return Optional.ofNullable(clazz.cast(this.dnsTargetResource()));
            }
            case "ReadinessScopes": {
                return Optional.ofNullable(clazz.cast(this.readinessScopes()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentId", COMPONENT_ID_FIELD);
        map.put("dnsTargetResource", DNS_TARGET_RESOURCE_FIELD);
        map.put("readinessScopes", READINESS_SCOPES_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentId;
        private DNSTargetResource dnsTargetResource;
        private List<String> readinessScopes = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.componentId(model.componentId);
            this.dnsTargetResource(model.dnsTargetResource);
            this.readinessScopes(model.readinessScopes);
            this.resourceArn(model.resourceArn);
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final DNSTargetResource.Builder getDnsTargetResource() {
            return this.dnsTargetResource != null ? this.dnsTargetResource.toBuilder() : null;
        }

        public final void setDnsTargetResource(DNSTargetResource.BuilderImpl dnsTargetResource) {
            this.dnsTargetResource = dnsTargetResource != null ? dnsTargetResource.build() : null;
        }

        @Override
        public final Builder dnsTargetResource(DNSTargetResource dnsTargetResource) {
            this.dnsTargetResource = dnsTargetResource;
            return this;
        }

        public final Collection<String> getReadinessScopes() {
            if (this.readinessScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readinessScopes;
        }

        public final void setReadinessScopes(Collection<String> readinessScopes) {
            this.readinessScopes = ___listOf__stringCopier.copy(readinessScopes);
        }

        @Override
        public final Builder readinessScopes(Collection<String> readinessScopes) {
            this.readinessScopes = ___listOf__stringCopier.copy(readinessScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessScopes(String ... readinessScopes) {
            this.readinessScopes(Arrays.asList(readinessScopes));
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder componentId(String var1);

        public Builder dnsTargetResource(DNSTargetResource var1);

        default public Builder dnsTargetResource(Consumer<DNSTargetResource.Builder> dnsTargetResource) {
            return this.dnsTargetResource((DNSTargetResource)((DNSTargetResource.Builder)DNSTargetResource.builder().applyMutation(dnsTargetResource)).build());
        }

        public Builder readinessScopes(Collection<String> var1);

        public Builder readinessScopes(String ... var1);

        public Builder resourceArn(String var1);
    }
}

