/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceResult;

public class GetReadinessCheckStatusPublisher
implements SdkPublisher<GetReadinessCheckStatusResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final GetReadinessCheckStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReadinessCheckStatusPublisher(Route53RecoveryReadinessAsyncClient client, GetReadinessCheckStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReadinessCheckStatusPublisher(Route53RecoveryReadinessAsyncClient client, GetReadinessCheckStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReadinessCheckStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReadinessCheckStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceResult> resources() {
        Function<GetReadinessCheckStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetReadinessCheckStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetReadinessCheckStatusResponseFetcher
    implements AsyncPageFetcher<GetReadinessCheckStatusResponse> {
        private GetReadinessCheckStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetReadinessCheckStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetReadinessCheckStatusResponse> nextPage(GetReadinessCheckStatusResponse previousPage) {
            if (previousPage == null) {
                return GetReadinessCheckStatusPublisher.this.client.getReadinessCheckStatus(GetReadinessCheckStatusPublisher.this.firstRequest);
            }
            return GetReadinessCheckStatusPublisher.this.client.getReadinessCheckStatus((GetReadinessCheckStatusRequest)((Object)GetReadinessCheckStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

