/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RuleResult;

public class GetReadinessCheckResourceStatusIterable
implements SdkIterable<GetReadinessCheckResourceStatusResponse> {
    private final Route53RecoveryReadinessClient client;
    private final GetReadinessCheckResourceStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReadinessCheckResourceStatusIterable(Route53RecoveryReadinessClient client, GetReadinessCheckResourceStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetReadinessCheckResourceStatusResponseFetcher();
    }

    public Iterator<GetReadinessCheckResourceStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleResult> rules() {
        Function<GetReadinessCheckResourceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetReadinessCheckResourceStatusResponseFetcher
    implements SyncPageFetcher<GetReadinessCheckResourceStatusResponse> {
        private GetReadinessCheckResourceStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetReadinessCheckResourceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetReadinessCheckResourceStatusResponse nextPage(GetReadinessCheckResourceStatusResponse previousPage) {
            if (previousPage == null) {
                return GetReadinessCheckResourceStatusIterable.this.client.getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusIterable.this.firstRequest);
            }
            return GetReadinessCheckResourceStatusIterable.this.client.getReadinessCheckResourceStatus((GetReadinessCheckResourceStatusRequest)((Object)GetReadinessCheckResourceStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

