/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesAsyncClient;
import software.amazon.awssdk.services.route53profiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ProfileResourceAssociation;

public class ListProfileResourceAssociationsPublisher
implements SdkPublisher<ListProfileResourceAssociationsResponse> {
    private final Route53ProfilesAsyncClient client;
    private final ListProfileResourceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileResourceAssociationsPublisher(Route53ProfilesAsyncClient client, ListProfileResourceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileResourceAssociationsPublisher(Route53ProfilesAsyncClient client, ListProfileResourceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileResourceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfileResourceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProfileResourceAssociation> profileResourceAssociations() {
        Function<ListProfileResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileResourceAssociations() != null) {
                return response.profileResourceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProfileResourceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProfileResourceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListProfileResourceAssociationsResponse> {
        private ListProfileResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfileResourceAssociationsResponse> nextPage(ListProfileResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileResourceAssociationsPublisher.this.client.listProfileResourceAssociations(ListProfileResourceAssociationsPublisher.this.firstRequest);
            }
            return ListProfileResourceAssociationsPublisher.this.client.listProfileResourceAssociations((ListProfileResourceAssociationsRequest)((Object)ListProfileResourceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

