/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53profiles.model.Route53ProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateResourceToProfileRequest
extends Route53ProfilesRequest
implements ToCopyableBuilder<Builder, AssociateResourceToProfileRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssociateResourceToProfileRequest.getter(AssociateResourceToProfileRequest::name)).setter(AssociateResourceToProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(AssociateResourceToProfileRequest.getter(AssociateResourceToProfileRequest::profileId)).setter(AssociateResourceToProfileRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AssociateResourceToProfileRequest.getter(AssociateResourceToProfileRequest::resourceArn)).setter(AssociateResourceToProfileRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceProperties").getter(AssociateResourceToProfileRequest.getter(AssociateResourceToProfileRequest::resourceProperties)).setter(AssociateResourceToProfileRequest.setter(Builder::resourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROFILE_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateResourceToProfileRequest.memberNameToFieldInitializer();
    private final String name;
    private final String profileId;
    private final String resourceArn;
    private final String resourceProperties;

    private AssociateResourceToProfileRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.profileId = builder.profileId;
        this.resourceArn = builder.resourceArn;
        this.resourceProperties = builder.resourceProperties;
    }

    public final String name() {
        return this.name;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceProperties() {
        return this.resourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceToProfileRequest)) {
            return false;
        }
        AssociateResourceToProfileRequest other = (AssociateResourceToProfileRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceProperties(), other.resourceProperties());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateResourceToProfileRequest").add("Name", (Object)this.name()).add("ProfileId", (Object)this.profileId()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceProperties", (Object)this.resourceProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceProperties": {
                return Optional.ofNullable(clazz.cast(this.resourceProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateResourceToProfileRequest, T> g) {
        return obj -> g.apply((AssociateResourceToProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ProfilesRequest.BuilderImpl
    implements Builder {
        private String name;
        private String profileId;
        private String resourceArn;
        private String resourceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResourceToProfileRequest model) {
            super(model);
            this.name(model.name);
            this.profileId(model.profileId);
            this.resourceArn(model.resourceArn);
            this.resourceProperties(model.resourceProperties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResourceToProfileRequest build() {
            return new AssociateResourceToProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53ProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateResourceToProfileRequest> {
        public Builder name(String var1);

        public Builder profileId(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceProperties(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

