/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.HostedZoneAssociationSummary;
import software.amazon.awssdk.services.route53globalresolver.model.HostedZoneAssociationsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHostedZoneAssociationsResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListHostedZoneAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListHostedZoneAssociationsResponse.getter(ListHostedZoneAssociationsResponse::nextToken)).setter(ListHostedZoneAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<HostedZoneAssociationSummary>> HOSTED_ZONE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hostedZoneAssociations").getter(ListHostedZoneAssociationsResponse.getter(ListHostedZoneAssociationsResponse::hostedZoneAssociations)).setter(ListHostedZoneAssociationsResponse.setter(Builder::hostedZoneAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostedZoneAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, HOSTED_ZONE_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHostedZoneAssociationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<HostedZoneAssociationSummary> hostedZoneAssociations;

    private ListHostedZoneAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.hostedZoneAssociations = builder.hostedZoneAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasHostedZoneAssociations() {
        return this.hostedZoneAssociations != null && !(this.hostedZoneAssociations instanceof SdkAutoConstructList);
    }

    public final List<HostedZoneAssociationSummary> hostedZoneAssociations() {
        return this.hostedZoneAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostedZoneAssociations() ? this.hostedZoneAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZoneAssociationsResponse)) {
            return false;
        }
        ListHostedZoneAssociationsResponse other = (ListHostedZoneAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasHostedZoneAssociations() == other.hasHostedZoneAssociations() && Objects.equals(this.hostedZoneAssociations(), other.hostedZoneAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListHostedZoneAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("HostedZoneAssociations", this.hasHostedZoneAssociations() ? this.hostedZoneAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "hostedZoneAssociations": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("hostedZoneAssociations", HOSTED_ZONE_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZoneAssociationsResponse, T> g) {
        return obj -> g.apply((ListHostedZoneAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HostedZoneAssociationSummary> hostedZoneAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZoneAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.hostedZoneAssociations(model.hostedZoneAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HostedZoneAssociationSummary.Builder> getHostedZoneAssociations() {
            List<HostedZoneAssociationSummary.Builder> result = HostedZoneAssociationsCopier.copyToBuilder(this.hostedZoneAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostedZoneAssociations(Collection<HostedZoneAssociationSummary.BuilderImpl> hostedZoneAssociations) {
            this.hostedZoneAssociations = HostedZoneAssociationsCopier.copyFromBuilder(hostedZoneAssociations);
        }

        @Override
        public final Builder hostedZoneAssociations(Collection<HostedZoneAssociationSummary> hostedZoneAssociations) {
            this.hostedZoneAssociations = HostedZoneAssociationsCopier.copy(hostedZoneAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneAssociations(HostedZoneAssociationSummary ... hostedZoneAssociations) {
            this.hostedZoneAssociations(Arrays.asList(hostedZoneAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZoneAssociations(Consumer<HostedZoneAssociationSummary.Builder> ... hostedZoneAssociations) {
            this.hostedZoneAssociations(Stream.of(hostedZoneAssociations).map(c -> (HostedZoneAssociationSummary)((HostedZoneAssociationSummary.Builder)HostedZoneAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListHostedZoneAssociationsResponse build() {
            return new ListHostedZoneAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHostedZoneAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder hostedZoneAssociations(Collection<HostedZoneAssociationSummary> var1);

        public Builder hostedZoneAssociations(HostedZoneAssociationSummary ... var1);

        public Builder hostedZoneAssociations(Consumer<HostedZoneAssociationSummary.Builder> ... var1);
    }
}

