/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.Consent;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainContactRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, UpdateDomainContactRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::domainName)).setter(UpdateDomainContactRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminContact").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::adminContact)).setter(UpdateDomainContactRequest.setter(Builder::adminContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()}).build();
    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistrantContact").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::registrantContact)).setter(UpdateDomainContactRequest.setter(Builder::registrantContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()}).build();
    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechContact").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::techContact)).setter(UpdateDomainContactRequest.setter(Builder::techContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()}).build();
    private static final SdkField<Consent> CONSENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Consent").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::consent)).setter(UpdateDomainContactRequest.setter(Builder::consent)).constructor(Consent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consent").build()}).build();
    private static final SdkField<ContactDetail> BILLING_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingContact").getter(UpdateDomainContactRequest.getter(UpdateDomainContactRequest::billingContact)).setter(UpdateDomainContactRequest.setter(Builder::billingContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingContact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD, TECH_CONTACT_FIELD, CONSENT_FIELD, BILLING_CONTACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDomainContactRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Consent consent;
    private final ContactDetail billingContact;

    private UpdateDomainContactRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.consent = builder.consent;
        this.billingContact = builder.billingContact;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ContactDetail adminContact() {
        return this.adminContact;
    }

    public final ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public final ContactDetail techContact() {
        return this.techContact;
    }

    public final Consent consent() {
        return this.consent;
    }

    public final ContactDetail billingContact() {
        return this.billingContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.consent());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingContact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactRequest)) {
            return false;
        }
        UpdateDomainContactRequest other = (UpdateDomainContactRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.consent(), other.consent()) && Objects.equals(this.billingContact(), other.billingContact());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainContactRequest").add("DomainName", (Object)this.domainName()).add("AdminContact", (Object)(this.adminContact() == null ? null : "*** Sensitive Data Redacted ***")).add("RegistrantContact", (Object)(this.registrantContact() == null ? null : "*** Sensitive Data Redacted ***")).add("TechContact", (Object)(this.techContact() == null ? null : "*** Sensitive Data Redacted ***")).add("Consent", (Object)this.consent()).add("BillingContact", (Object)(this.billingContact() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AdminContact": {
                return Optional.ofNullable(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.ofNullable(clazz.cast(this.techContact()));
            }
            case "Consent": {
                return Optional.ofNullable(clazz.cast(this.consent()));
            }
            case "BillingContact": {
                return Optional.ofNullable(clazz.cast(this.billingContact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("AdminContact", ADMIN_CONTACT_FIELD);
        map.put("RegistrantContact", REGISTRANT_CONTACT_FIELD);
        map.put("TechContact", TECH_CONTACT_FIELD);
        map.put("Consent", CONSENT_FIELD);
        map.put("BillingContact", BILLING_CONTACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainContactRequest, T> g) {
        return obj -> g.apply((UpdateDomainContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Consent consent;
        private ContactDetail billingContact;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.consent(model.consent);
            this.billingContact(model.billingContact);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final Consent.Builder getConsent() {
            return this.consent != null ? this.consent.toBuilder() : null;
        }

        public final void setConsent(Consent.BuilderImpl consent) {
            this.consent = consent != null ? consent.build() : null;
        }

        @Override
        public final Builder consent(Consent consent) {
            this.consent = consent;
            return this;
        }

        public final ContactDetail.Builder getBillingContact() {
            return this.billingContact != null ? this.billingContact.toBuilder() : null;
        }

        public final void setBillingContact(ContactDetail.BuilderImpl billingContact) {
            this.billingContact = billingContact != null ? billingContact.build() : null;
        }

        @Override
        public final Builder billingContact(ContactDetail billingContact) {
            this.billingContact = billingContact;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainContactRequest build() {
            return new UpdateDomainContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainContactRequest> {
        public Builder domainName(String var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(techContact)).build());
        }

        public Builder consent(Consent var1);

        default public Builder consent(Consumer<Consent.Builder> consent) {
            return this.consent((Consent)((Consent.Builder)Consent.builder().applyMutation(consent)).build());
        }

        public Builder billingContact(ContactDetail var1);

        default public Builder billingContact(Consumer<ContactDetail.Builder> billingContact) {
            return this.billingContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(billingContact)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

