/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, RegisterDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(RegisterDomainRequest.getter(RegisterDomainRequest::domainName)).setter(RegisterDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> IDN_LANG_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdnLangCode").getter(RegisterDomainRequest.getter(RegisterDomainRequest::idnLangCode)).setter(RegisterDomainRequest.setter(Builder::idnLangCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdnLangCode").build()}).build();
    private static final SdkField<Integer> DURATION_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInYears").getter(RegisterDomainRequest.getter(RegisterDomainRequest::durationInYears)).setter(RegisterDomainRequest.setter(Builder::durationInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInYears").build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoRenew").getter(RegisterDomainRequest.getter(RegisterDomainRequest::autoRenew)).setter(RegisterDomainRequest.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::adminContact)).setter(RegisterDomainRequest.setter(Builder::adminContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()}).build();
    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistrantContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::registrantContact)).setter(RegisterDomainRequest.setter(Builder::registrantContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()}).build();
    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::techContact)).setter(RegisterDomainRequest.setter(Builder::techContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivacyProtectAdminContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::privacyProtectAdminContact)).setter(RegisterDomainRequest.setter(Builder::privacyProtectAdminContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectAdminContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivacyProtectRegistrantContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::privacyProtectRegistrantContact)).setter(RegisterDomainRequest.setter(Builder::privacyProtectRegistrantContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectRegistrantContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivacyProtectTechContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::privacyProtectTechContact)).setter(RegisterDomainRequest.setter(Builder::privacyProtectTechContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectTechContact").build()}).build();
    private static final SdkField<ContactDetail> BILLING_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::billingContact)).setter(RegisterDomainRequest.setter(Builder::billingContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingContact").build()}).build();
    private static final SdkField<Boolean> PRIVACY_PROTECT_BILLING_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivacyProtectBillingContact").getter(RegisterDomainRequest.getter(RegisterDomainRequest::privacyProtectBillingContact)).setter(RegisterDomainRequest.setter(Builder::privacyProtectBillingContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectBillingContact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, IDN_LANG_CODE_FIELD, DURATION_IN_YEARS_FIELD, AUTO_RENEW_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD, TECH_CONTACT_FIELD, PRIVACY_PROTECT_ADMIN_CONTACT_FIELD, PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD, PRIVACY_PROTECT_TECH_CONTACT_FIELD, BILLING_CONTACT_FIELD, PRIVACY_PROTECT_BILLING_CONTACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterDomainRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String idnLangCode;
    private final Integer durationInYears;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean privacyProtectAdminContact;
    private final Boolean privacyProtectRegistrantContact;
    private final Boolean privacyProtectTechContact;
    private final ContactDetail billingContact;
    private final Boolean privacyProtectBillingContact;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
        this.billingContact = builder.billingContact;
        this.privacyProtectBillingContact = builder.privacyProtectBillingContact;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String idnLangCode() {
        return this.idnLangCode;
    }

    public final Integer durationInYears() {
        return this.durationInYears;
    }

    public final Boolean autoRenew() {
        return this.autoRenew;
    }

    public final ContactDetail adminContact() {
        return this.adminContact;
    }

    public final ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public final ContactDetail techContact() {
        return this.techContact;
    }

    public final Boolean privacyProtectAdminContact() {
        return this.privacyProtectAdminContact;
    }

    public final Boolean privacyProtectRegistrantContact() {
        return this.privacyProtectRegistrantContact;
    }

    public final Boolean privacyProtectTechContact() {
        return this.privacyProtectTechContact;
    }

    public final ContactDetail billingContact() {
        return this.billingContact;
    }

    public final Boolean privacyProtectBillingContact() {
        return this.privacyProtectBillingContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.idnLangCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectAdminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectRegistrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectTechContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectBillingContact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.idnLangCode(), other.idnLangCode()) && Objects.equals(this.durationInYears(), other.durationInYears()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.privacyProtectAdminContact(), other.privacyProtectAdminContact()) && Objects.equals(this.privacyProtectRegistrantContact(), other.privacyProtectRegistrantContact()) && Objects.equals(this.privacyProtectTechContact(), other.privacyProtectTechContact()) && Objects.equals(this.billingContact(), other.billingContact()) && Objects.equals(this.privacyProtectBillingContact(), other.privacyProtectBillingContact());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterDomainRequest").add("DomainName", (Object)this.domainName()).add("IdnLangCode", (Object)this.idnLangCode()).add("DurationInYears", (Object)this.durationInYears()).add("AutoRenew", (Object)this.autoRenew()).add("AdminContact", (Object)(this.adminContact() == null ? null : "*** Sensitive Data Redacted ***")).add("RegistrantContact", (Object)(this.registrantContact() == null ? null : "*** Sensitive Data Redacted ***")).add("TechContact", (Object)(this.techContact() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivacyProtectAdminContact", (Object)this.privacyProtectAdminContact()).add("PrivacyProtectRegistrantContact", (Object)this.privacyProtectRegistrantContact()).add("PrivacyProtectTechContact", (Object)this.privacyProtectTechContact()).add("BillingContact", (Object)(this.billingContact() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivacyProtectBillingContact", (Object)this.privacyProtectBillingContact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.ofNullable(clazz.cast(this.idnLangCode()));
            }
            case "DurationInYears": {
                return Optional.ofNullable(clazz.cast(this.durationInYears()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "AdminContact": {
                return Optional.ofNullable(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.ofNullable(clazz.cast(this.techContact()));
            }
            case "PrivacyProtectAdminContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectAdminContact()));
            }
            case "PrivacyProtectRegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectRegistrantContact()));
            }
            case "PrivacyProtectTechContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectTechContact()));
            }
            case "BillingContact": {
                return Optional.ofNullable(clazz.cast(this.billingContact()));
            }
            case "PrivacyProtectBillingContact": {
                return Optional.ofNullable(clazz.cast(this.privacyProtectBillingContact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("IdnLangCode", IDN_LANG_CODE_FIELD);
        map.put("DurationInYears", DURATION_IN_YEARS_FIELD);
        map.put("AutoRenew", AUTO_RENEW_FIELD);
        map.put("AdminContact", ADMIN_CONTACT_FIELD);
        map.put("RegistrantContact", REGISTRANT_CONTACT_FIELD);
        map.put("TechContact", TECH_CONTACT_FIELD);
        map.put("PrivacyProtectAdminContact", PRIVACY_PROTECT_ADMIN_CONTACT_FIELD);
        map.put("PrivacyProtectRegistrantContact", PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD);
        map.put("PrivacyProtectTechContact", PRIVACY_PROTECT_TECH_CONTACT_FIELD);
        map.put("BillingContact", BILLING_CONTACT_FIELD);
        map.put("PrivacyProtectBillingContact", PRIVACY_PROTECT_BILLING_CONTACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterDomainRequest, T> g) {
        return obj -> g.apply((RegisterDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;
        private Integer durationInYears;
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean privacyProtectAdminContact;
        private Boolean privacyProtectRegistrantContact;
        private Boolean privacyProtectTechContact;
        private ContactDetail billingContact;
        private Boolean privacyProtectBillingContact;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
            this.durationInYears(model.durationInYears);
            this.autoRenew(model.autoRenew);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.privacyProtectAdminContact(model.privacyProtectAdminContact);
            this.privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            this.privacyProtectTechContact(model.privacyProtectTechContact);
            this.billingContact(model.billingContact);
            this.privacyProtectBillingContact(model.privacyProtectBillingContact);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return this.privacyProtectAdminContact;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return this.privacyProtectRegistrantContact;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return this.privacyProtectTechContact;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        public final ContactDetail.Builder getBillingContact() {
            return this.billingContact != null ? this.billingContact.toBuilder() : null;
        }

        public final void setBillingContact(ContactDetail.BuilderImpl billingContact) {
            this.billingContact = billingContact != null ? billingContact.build() : null;
        }

        @Override
        public final Builder billingContact(ContactDetail billingContact) {
            this.billingContact = billingContact;
            return this;
        }

        public final Boolean getPrivacyProtectBillingContact() {
            return this.privacyProtectBillingContact;
        }

        public final void setPrivacyProtectBillingContact(Boolean privacyProtectBillingContact) {
            this.privacyProtectBillingContact = privacyProtectBillingContact;
        }

        @Override
        public final Builder privacyProtectBillingContact(Boolean privacyProtectBillingContact) {
            this.privacyProtectBillingContact = privacyProtectBillingContact;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterDomainRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);

        public Builder durationInYears(Integer var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(techContact)).build());
        }

        public Builder privacyProtectAdminContact(Boolean var1);

        public Builder privacyProtectRegistrantContact(Boolean var1);

        public Builder privacyProtectTechContact(Boolean var1);

        public Builder billingContact(ContactDetail var1);

        default public Builder billingContact(Consumer<ContactDetail.Builder> billingContact) {
            return this.billingContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(billingContact)).build());
        }

        public Builder privacyProtectBillingContact(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

