/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;

public class ListHostedZonesIterable
implements SdkIterable<ListHostedZonesResponse> {
    private final Route53Client client;
    private final ListHostedZonesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostedZonesIterable(Route53Client client, ListHostedZonesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHostedZonesResponseFetcher();
    }

    public Iterator<ListHostedZonesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HostedZone> hostedZones() {
        Function<ListHostedZonesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hostedZones() != null) {
                return response.hostedZones().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHostedZonesResponseFetcher
    implements SyncPageFetcher<ListHostedZonesResponse> {
        private ListHostedZonesResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedZonesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListHostedZonesResponse nextPage(ListHostedZonesResponse previousPage) {
            if (previousPage == null) {
                return ListHostedZonesIterable.this.client.listHostedZones(ListHostedZonesIterable.this.firstRequest);
            }
            return ListHostedZonesIterable.this.client.listHostedZones((ListHostedZonesRequest)((Object)ListHostedZonesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

