/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.AttributeMapping;
import software.amazon.awssdk.services.rolesanywhere.model.AttributeMappingsCopier;
import software.amazon.awssdk.services.rolesanywhere.model.ManagedPolicyListCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RoleArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileDetail> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(ProfileDetail.getter(ProfileDetail::profileId)).setter(ProfileDetail.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileArn").getter(ProfileDetail.getter(ProfileDetail::profileArn)).setter(ProfileDetail.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ProfileDetail.getter(ProfileDetail::name)).setter(ProfileDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> REQUIRE_INSTANCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("requireInstanceProperties").getter(ProfileDetail.getter(ProfileDetail::requireInstanceProperties)).setter(ProfileDetail.setter(Builder::requireInstanceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requireInstanceProperties").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(ProfileDetail.getter(ProfileDetail::enabled)).setter(ProfileDetail.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ProfileDetail.getter(ProfileDetail::createdBy)).setter(ProfileDetail.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> SESSION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionPolicy").getter(ProfileDetail.getter(ProfileDetail::sessionPolicy)).setter(ProfileDetail.setter(Builder::sessionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPolicy").build()}).build();
    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roleArns").getter(ProfileDetail.getter(ProfileDetail::roleArns)).setter(ProfileDetail.setter(Builder::roleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MANAGED_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedPolicyArns").getter(ProfileDetail.getter(ProfileDetail::managedPolicyArns)).setter(ProfileDetail.setter(Builder::managedPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ProfileDetail.getter(ProfileDetail::createdAt)).setter(ProfileDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ProfileDetail.getter(ProfileDetail::updatedAt)).setter(ProfileDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("durationSeconds").getter(ProfileDetail.getter(ProfileDetail::durationSeconds)).setter(ProfileDetail.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()}).build();
    private static final SdkField<Boolean> ACCEPT_ROLE_SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("acceptRoleSessionName").getter(ProfileDetail.getter(ProfileDetail::acceptRoleSessionName)).setter(ProfileDetail.setter(Builder::acceptRoleSessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptRoleSessionName").build()}).build();
    private static final SdkField<List<AttributeMapping>> ATTRIBUTE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeMappings").getter(ProfileDetail.getter(ProfileDetail::attributeMappings)).setter(ProfileDetail.setter(Builder::attributeMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, PROFILE_ARN_FIELD, NAME_FIELD, REQUIRE_INSTANCE_PROPERTIES_FIELD, ENABLED_FIELD, CREATED_BY_FIELD, SESSION_POLICY_FIELD, ROLE_ARNS_FIELD, MANAGED_POLICY_ARNS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DURATION_SECONDS_FIELD, ACCEPT_ROLE_SESSION_NAME_FIELD, ATTRIBUTE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProfileDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String profileArn;
    private final String name;
    private final Boolean requireInstanceProperties;
    private final Boolean enabled;
    private final String createdBy;
    private final String sessionPolicy;
    private final List<String> roleArns;
    private final List<String> managedPolicyArns;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Integer durationSeconds;
    private final Boolean acceptRoleSessionName;
    private final List<AttributeMapping> attributeMappings;

    private ProfileDetail(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.profileArn = builder.profileArn;
        this.name = builder.name;
        this.requireInstanceProperties = builder.requireInstanceProperties;
        this.enabled = builder.enabled;
        this.createdBy = builder.createdBy;
        this.sessionPolicy = builder.sessionPolicy;
        this.roleArns = builder.roleArns;
        this.managedPolicyArns = builder.managedPolicyArns;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.durationSeconds = builder.durationSeconds;
        this.acceptRoleSessionName = builder.acceptRoleSessionName;
        this.attributeMappings = builder.attributeMappings;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean requireInstanceProperties() {
        return this.requireInstanceProperties;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String sessionPolicy() {
        return this.sessionPolicy;
    }

    public final boolean hasRoleArns() {
        return this.roleArns != null && !(this.roleArns instanceof SdkAutoConstructList);
    }

    public final List<String> roleArns() {
        return this.roleArns;
    }

    public final boolean hasManagedPolicyArns() {
        return this.managedPolicyArns != null && !(this.managedPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> managedPolicyArns() {
        return this.managedPolicyArns;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final Boolean acceptRoleSessionName() {
        return this.acceptRoleSessionName;
    }

    public final boolean hasAttributeMappings() {
        return this.attributeMappings != null && !(this.attributeMappings instanceof SdkAutoConstructList);
    }

    public final List<AttributeMapping> attributeMappings() {
        return this.attributeMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleArns() ? this.roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedPolicyArns() ? this.managedPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRoleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeMappings() ? this.attributeMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileDetail)) {
            return false;
        }
        ProfileDetail other = (ProfileDetail)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requireInstanceProperties(), other.requireInstanceProperties()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.sessionPolicy(), other.sessionPolicy()) && this.hasRoleArns() == other.hasRoleArns() && Objects.equals(this.roleArns(), other.roleArns()) && this.hasManagedPolicyArns() == other.hasManagedPolicyArns() && Objects.equals(this.managedPolicyArns(), other.managedPolicyArns()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.acceptRoleSessionName(), other.acceptRoleSessionName()) && this.hasAttributeMappings() == other.hasAttributeMappings() && Objects.equals(this.attributeMappings(), other.attributeMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileDetail").add("ProfileId", (Object)this.profileId()).add("ProfileArn", (Object)this.profileArn()).add("Name", (Object)this.name()).add("RequireInstanceProperties", (Object)this.requireInstanceProperties()).add("Enabled", (Object)this.enabled()).add("CreatedBy", (Object)this.createdBy()).add("SessionPolicy", (Object)this.sessionPolicy()).add("RoleArns", this.hasRoleArns() ? this.roleArns() : null).add("ManagedPolicyArns", this.hasManagedPolicyArns() ? this.managedPolicyArns() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DurationSeconds", (Object)this.durationSeconds()).add("AcceptRoleSessionName", (Object)this.acceptRoleSessionName()).add("AttributeMappings", this.hasAttributeMappings() ? this.attributeMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "profileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requireInstanceProperties": {
                return Optional.ofNullable(clazz.cast(this.requireInstanceProperties()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "sessionPolicy": {
                return Optional.ofNullable(clazz.cast(this.sessionPolicy()));
            }
            case "roleArns": {
                return Optional.ofNullable(clazz.cast(this.roleArns()));
            }
            case "managedPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.managedPolicyArns()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "acceptRoleSessionName": {
                return Optional.ofNullable(clazz.cast(this.acceptRoleSessionName()));
            }
            case "attributeMappings": {
                return Optional.ofNullable(clazz.cast(this.attributeMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("profileArn", PROFILE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requireInstanceProperties", REQUIRE_INSTANCE_PROPERTIES_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("sessionPolicy", SESSION_POLICY_FIELD);
        map.put("roleArns", ROLE_ARNS_FIELD);
        map.put("managedPolicyArns", MANAGED_POLICY_ARNS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("acceptRoleSessionName", ACCEPT_ROLE_SESSION_NAME_FIELD);
        map.put("attributeMappings", ATTRIBUTE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileDetail, T> g) {
        return obj -> g.apply((ProfileDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String profileArn;
        private String name;
        private Boolean requireInstanceProperties;
        private Boolean enabled;
        private String createdBy;
        private String sessionPolicy;
        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> managedPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;
        private Integer durationSeconds;
        private Boolean acceptRoleSessionName;
        private List<AttributeMapping> attributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileDetail model) {
            this.profileId(model.profileId);
            this.profileArn(model.profileArn);
            this.name(model.name);
            this.requireInstanceProperties(model.requireInstanceProperties);
            this.enabled(model.enabled);
            this.createdBy(model.createdBy);
            this.sessionPolicy(model.sessionPolicy);
            this.roleArns(model.roleArns);
            this.managedPolicyArns(model.managedPolicyArns);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.durationSeconds(model.durationSeconds);
            this.acceptRoleSessionName(model.acceptRoleSessionName);
            this.attributeMappings(model.attributeMappings);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getRequireInstanceProperties() {
            return this.requireInstanceProperties;
        }

        public final void setRequireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
        }

        @Override
        public final Builder requireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getSessionPolicy() {
            return this.sessionPolicy;
        }

        public final void setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
        }

        @Override
        public final Builder sessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (this.roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String ... roleArns) {
            this.roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final Collection<String> getManagedPolicyArns() {
            if (this.managedPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedPolicyArns;
        }

        public final void setManagedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
        }

        @Override
        public final Builder managedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedPolicyArns(String ... managedPolicyArns) {
            this.managedPolicyArns(Arrays.asList(managedPolicyArns));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Boolean getAcceptRoleSessionName() {
            return this.acceptRoleSessionName;
        }

        public final void setAcceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
        }

        @Override
        public final Builder acceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
            return this;
        }

        public final List<AttributeMapping.Builder> getAttributeMappings() {
            List<AttributeMapping.Builder> result = AttributeMappingsCopier.copyToBuilder(this.attributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeMappings(Collection<AttributeMapping.BuilderImpl> attributeMappings) {
            this.attributeMappings = AttributeMappingsCopier.copyFromBuilder(attributeMappings);
        }

        @Override
        public final Builder attributeMappings(Collection<AttributeMapping> attributeMappings) {
            this.attributeMappings = AttributeMappingsCopier.copy(attributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeMappings(AttributeMapping ... attributeMappings) {
            this.attributeMappings(Arrays.asList(attributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeMappings(Consumer<AttributeMapping.Builder> ... attributeMappings) {
            this.attributeMappings(Stream.of(attributeMappings).map(c -> (AttributeMapping)((AttributeMapping.Builder)AttributeMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProfileDetail build() {
            return new ProfileDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileDetail> {
        public Builder profileId(String var1);

        public Builder profileArn(String var1);

        public Builder name(String var1);

        public Builder requireInstanceProperties(Boolean var1);

        public Builder enabled(Boolean var1);

        public Builder createdBy(String var1);

        public Builder sessionPolicy(String var1);

        public Builder roleArns(Collection<String> var1);

        public Builder roleArns(String ... var1);

        public Builder managedPolicyArns(Collection<String> var1);

        public Builder managedPolicyArns(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder durationSeconds(Integer var1);

        public Builder acceptRoleSessionName(Boolean var1);

        public Builder attributeMappings(Collection<AttributeMapping> var1);

        public Builder attributeMappings(AttributeMapping ... var1);

        public Builder attributeMappings(Consumer<AttributeMapping.Builder> ... var1);
    }
}

