/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingsCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.services.rolesanywhere.model.Source;
import software.amazon.awssdk.services.rolesanywhere.model.Tag;
import software.amazon.awssdk.services.rolesanywhere.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustAnchorRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, CreateTrustAnchorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTrustAnchorRequest.getter(CreateTrustAnchorRequest::name)).setter(CreateTrustAnchorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateTrustAnchorRequest.getter(CreateTrustAnchorRequest::source)).setter(CreateTrustAnchorRequest.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateTrustAnchorRequest.getter(CreateTrustAnchorRequest::enabled)).setter(CreateTrustAnchorRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateTrustAnchorRequest.getter(CreateTrustAnchorRequest::tags)).setter(CreateTrustAnchorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NotificationSetting>> NOTIFICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationSettings").getter(CreateTrustAnchorRequest.getter(CreateTrustAnchorRequest::notificationSettings)).setter(CreateTrustAnchorRequest.setter(Builder::notificationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD, ENABLED_FIELD, TAGS_FIELD, NOTIFICATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrustAnchorRequest.memberNameToFieldInitializer();
    private final String name;
    private final Source source;
    private final Boolean enabled;
    private final List<Tag> tags;
    private final List<NotificationSetting> notificationSettings;

    private CreateTrustAnchorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.source = builder.source;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
        this.notificationSettings = builder.notificationSettings;
    }

    public final String name() {
        return this.name;
    }

    public final Source source() {
        return this.source;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasNotificationSettings() {
        return this.notificationSettings != null && !(this.notificationSettings instanceof SdkAutoConstructList);
    }

    public final List<NotificationSetting> notificationSettings() {
        return this.notificationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationSettings() ? this.notificationSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustAnchorRequest)) {
            return false;
        }
        CreateTrustAnchorRequest other = (CreateTrustAnchorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.enabled(), other.enabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasNotificationSettings() == other.hasNotificationSettings() && Objects.equals(this.notificationSettings(), other.notificationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrustAnchorRequest").add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("Enabled", (Object)this.enabled()).add("Tags", this.hasTags() ? this.tags() : null).add("NotificationSettings", this.hasNotificationSettings() ? this.notificationSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "notificationSettings": {
                return Optional.ofNullable(clazz.cast(this.notificationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("notificationSettings", NOTIFICATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustAnchorRequest, T> g) {
        return obj -> g.apply((CreateTrustAnchorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private String name;
        private Source source;
        private Boolean enabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<NotificationSetting> notificationSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustAnchorRequest model) {
            super(model);
            this.name(model.name);
            this.source(model.source);
            this.enabled(model.enabled);
            this.tags(model.tags);
            this.notificationSettings(model.notificationSettings);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NotificationSetting.Builder> getNotificationSettings() {
            List<NotificationSetting.Builder> result = NotificationSettingsCopier.copyToBuilder(this.notificationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettings(Collection<NotificationSetting.BuilderImpl> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copyFromBuilder(notificationSettings);
        }

        @Override
        public final Builder notificationSettings(Collection<NotificationSetting> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copy(notificationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(NotificationSetting ... notificationSettings) {
            this.notificationSettings(Arrays.asList(notificationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(Consumer<NotificationSetting.Builder> ... notificationSettings) {
            this.notificationSettings(Stream.of(notificationSettings).map(c -> (NotificationSetting)((NotificationSetting.Builder)NotificationSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustAnchorRequest build() {
            return new CreateTrustAnchorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustAnchorRequest> {
        public Builder name(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notificationSettings(Collection<NotificationSetting> var1);

        public Builder notificationSettings(NotificationSetting ... var1);

        public Builder notificationSettings(Consumer<NotificationSetting.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

