/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgressDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgressDetail> {
    private static final SdkField<String> CURRENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentProgress").getter(ProgressDetail.getter(ProgressDetail::currentProgressAsString)).setter(ProgressDetail.setter(Builder::currentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentProgress").build()}).build();
    private static final SdkField<Float> PERCENT_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentDone").getter(ProgressDetail.getter(ProgressDetail::percentDone)).setter(ProgressDetail.setter(Builder::percentDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentDone").build()}).build();
    private static final SdkField<Integer> ESTIMATED_TIME_REMAINING_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("estimatedTimeRemainingSeconds").getter(ProgressDetail.getter(ProgressDetail::estimatedTimeRemainingSeconds)).setter(ProgressDetail.setter(Builder::estimatedTimeRemainingSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTimeRemainingSeconds").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResource").getter(ProgressDetail.getter(ProgressDetail::targetResource)).setter(ProgressDetail.setter(Builder::targetResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PROGRESS_FIELD, PERCENT_DONE_FIELD, ESTIMATED_TIME_REMAINING_SECONDS_FIELD, TARGET_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProgressDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currentProgress;
    private final Float percentDone;
    private final Integer estimatedTimeRemainingSeconds;
    private final String targetResource;

    private ProgressDetail(BuilderImpl builder) {
        this.currentProgress = builder.currentProgress;
        this.percentDone = builder.percentDone;
        this.estimatedTimeRemainingSeconds = builder.estimatedTimeRemainingSeconds;
        this.targetResource = builder.targetResource;
    }

    public final RobotDeploymentStep currentProgress() {
        return RobotDeploymentStep.fromValue(this.currentProgress);
    }

    public final String currentProgressAsString() {
        return this.currentProgress;
    }

    public final Float percentDone() {
        return this.percentDone;
    }

    public final Integer estimatedTimeRemainingSeconds() {
        return this.estimatedTimeRemainingSeconds;
    }

    public final String targetResource() {
        return this.targetResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentProgressAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressDetail)) {
            return false;
        }
        ProgressDetail other = (ProgressDetail)obj;
        return Objects.equals(this.currentProgressAsString(), other.currentProgressAsString()) && Objects.equals(this.percentDone(), other.percentDone()) && Objects.equals(this.estimatedTimeRemainingSeconds(), other.estimatedTimeRemainingSeconds()) && Objects.equals(this.targetResource(), other.targetResource());
    }

    public final String toString() {
        return ToString.builder((String)"ProgressDetail").add("CurrentProgress", (Object)this.currentProgressAsString()).add("PercentDone", (Object)this.percentDone()).add("EstimatedTimeRemainingSeconds", (Object)this.estimatedTimeRemainingSeconds()).add("TargetResource", (Object)this.targetResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currentProgress": {
                return Optional.ofNullable(clazz.cast(this.currentProgressAsString()));
            }
            case "percentDone": {
                return Optional.ofNullable(clazz.cast(this.percentDone()));
            }
            case "estimatedTimeRemainingSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingSeconds()));
            }
            case "targetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentProgress", CURRENT_PROGRESS_FIELD);
        map.put("percentDone", PERCENT_DONE_FIELD);
        map.put("estimatedTimeRemainingSeconds", ESTIMATED_TIME_REMAINING_SECONDS_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgressDetail, T> g) {
        return obj -> g.apply((ProgressDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentProgress;
        private Float percentDone;
        private Integer estimatedTimeRemainingSeconds;
        private String targetResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressDetail model) {
            this.currentProgress(model.currentProgress);
            this.percentDone(model.percentDone);
            this.estimatedTimeRemainingSeconds(model.estimatedTimeRemainingSeconds);
            this.targetResource(model.targetResource);
        }

        public final String getCurrentProgress() {
            return this.currentProgress;
        }

        public final void setCurrentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
        }

        @Override
        public final Builder currentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
            return this;
        }

        @Override
        public final Builder currentProgress(RobotDeploymentStep currentProgress) {
            this.currentProgress(currentProgress == null ? null : currentProgress.toString());
            return this;
        }

        public final Float getPercentDone() {
            return this.percentDone;
        }

        public final void setPercentDone(Float percentDone) {
            this.percentDone = percentDone;
        }

        @Override
        public final Builder percentDone(Float percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final Integer getEstimatedTimeRemainingSeconds() {
            return this.estimatedTimeRemainingSeconds;
        }

        public final void setEstimatedTimeRemainingSeconds(Integer estimatedTimeRemainingSeconds) {
            this.estimatedTimeRemainingSeconds = estimatedTimeRemainingSeconds;
        }

        @Override
        public final Builder estimatedTimeRemainingSeconds(Integer estimatedTimeRemainingSeconds) {
            this.estimatedTimeRemainingSeconds = estimatedTimeRemainingSeconds;
            return this;
        }

        public final String getTargetResource() {
            return this.targetResource;
        }

        public final void setTargetResource(String targetResource) {
            this.targetResource = targetResource;
        }

        @Override
        public final Builder targetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public ProgressDetail build() {
            return new ProgressDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgressDetail> {
        public Builder currentProgress(String var1);

        public Builder currentProgress(RobotDeploymentStep var1);

        public Builder percentDone(Float var1);

        public Builder estimatedTimeRemainingSeconds(Integer var1);

        public Builder targetResource(String var1);
    }
}

