/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RobotDeploymentStep {
    VALIDATING("Validating"),
    DOWNLOADING_EXTRACTING("DownloadingExtracting"),
    EXECUTING_DOWNLOAD_CONDITION("ExecutingDownloadCondition"),
    EXECUTING_PRE_LAUNCH("ExecutingPreLaunch"),
    LAUNCHING("Launching"),
    EXECUTING_POST_LAUNCH("ExecutingPostLaunch"),
    FINISHED("Finished"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RobotDeploymentStep> VALUE_MAP;
    private final String value;

    private RobotDeploymentStep(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RobotDeploymentStep fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RobotDeploymentStep> knownValues() {
        EnumSet<RobotDeploymentStep> knownValues = EnumSet.allOf(RobotDeploymentStep.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RobotDeploymentStep.class, RobotDeploymentStep::toString);
    }
}

