/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.RegionListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteResourceExplorerSetupRequest
extends ResourceExplorer2Request
implements ToCopyableBuilder<Builder, DeleteResourceExplorerSetupRequest> {
    private static final SdkField<List<String>> REGION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionList").getter(DeleteResourceExplorerSetupRequest.getter(DeleteResourceExplorerSetupRequest::regionList)).setter(DeleteResourceExplorerSetupRequest.setter(Builder::regionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_IN_ALL_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteInAllRegions").getter(DeleteResourceExplorerSetupRequest.getter(DeleteResourceExplorerSetupRequest::deleteInAllRegions)).setter(DeleteResourceExplorerSetupRequest.setter(Builder::deleteInAllRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteInAllRegions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_LIST_FIELD, DELETE_IN_ALL_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteResourceExplorerSetupRequest.memberNameToFieldInitializer();
    private final List<String> regionList;
    private final Boolean deleteInAllRegions;

    private DeleteResourceExplorerSetupRequest(BuilderImpl builder) {
        super(builder);
        this.regionList = builder.regionList;
        this.deleteInAllRegions = builder.deleteInAllRegions;
    }

    public final boolean hasRegionList() {
        return this.regionList != null && !(this.regionList instanceof SdkAutoConstructList);
    }

    public final List<String> regionList() {
        return this.regionList;
    }

    public final Boolean deleteInAllRegions() {
        return this.deleteInAllRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionList() ? this.regionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteInAllRegions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceExplorerSetupRequest)) {
            return false;
        }
        DeleteResourceExplorerSetupRequest other = (DeleteResourceExplorerSetupRequest)((Object)obj);
        return this.hasRegionList() == other.hasRegionList() && Objects.equals(this.regionList(), other.regionList()) && Objects.equals(this.deleteInAllRegions(), other.deleteInAllRegions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteResourceExplorerSetupRequest").add("RegionList", this.hasRegionList() ? this.regionList() : null).add("DeleteInAllRegions", (Object)this.deleteInAllRegions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionList": {
                return Optional.ofNullable(clazz.cast(this.regionList()));
            }
            case "DeleteInAllRegions": {
                return Optional.ofNullable(clazz.cast(this.deleteInAllRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionList", REGION_LIST_FIELD);
        map.put("DeleteInAllRegions", DELETE_IN_ALL_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceExplorerSetupRequest, T> g) {
        return obj -> g.apply((DeleteResourceExplorerSetupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Request.BuilderImpl
    implements Builder {
        private List<String> regionList = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteInAllRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceExplorerSetupRequest model) {
            super(model);
            this.regionList(model.regionList);
            this.deleteInAllRegions(model.deleteInAllRegions);
        }

        public final Collection<String> getRegionList() {
            if (this.regionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionList;
        }

        public final void setRegionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
        }

        @Override
        public final Builder regionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionList(String ... regionList) {
            this.regionList(Arrays.asList(regionList));
            return this;
        }

        public final Boolean getDeleteInAllRegions() {
            return this.deleteInAllRegions;
        }

        public final void setDeleteInAllRegions(Boolean deleteInAllRegions) {
            this.deleteInAllRegions = deleteInAllRegions;
        }

        @Override
        public final Builder deleteInAllRegions(Boolean deleteInAllRegions) {
            this.deleteInAllRegions = deleteInAllRegions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourceExplorerSetupRequest build() {
            return new DeleteResourceExplorerSetupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceExplorer2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteResourceExplorerSetupRequest> {
        public Builder regionList(Collection<String> var1);

        public Builder regionList(String ... var1);

        public Builder deleteInAllRegions(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

