/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus;

public class GetResourceExplorerSetupIterable
implements SdkIterable<GetResourceExplorerSetupResponse> {
    private final ResourceExplorer2Client client;
    private final GetResourceExplorerSetupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceExplorerSetupIterable(ResourceExplorer2Client client, GetResourceExplorerSetupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetResourceExplorerSetupResponseFetcher();
    }

    public Iterator<GetResourceExplorerSetupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegionStatus> regions() {
        Function<GetResourceExplorerSetupResponse, Iterator> getIterator = response -> {
            if (response != null && response.regions() != null) {
                return response.regions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourceExplorerSetupResponseFetcher
    implements SyncPageFetcher<GetResourceExplorerSetupResponse> {
        private GetResourceExplorerSetupResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceExplorerSetupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceExplorerSetupResponse nextPage(GetResourceExplorerSetupResponse previousPage) {
            if (previousPage == null) {
                return GetResourceExplorerSetupIterable.this.client.getResourceExplorerSetup(GetResourceExplorerSetupIterable.this.firstRequest);
            }
            return GetResourceExplorerSetupIterable.this.client.getResourceExplorerSetup((GetResourceExplorerSetupRequest)((Object)GetResourceExplorerSetupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

