/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourcePropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Resource.getter(Resource::arn)).setter(Resource.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> OWNING_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwningAccountId").getter(Resource.getter(Resource::owningAccountId)).setter(Resource.setter(Builder::owningAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningAccountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Resource.getter(Resource::region)).setter(Resource.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Resource.getter(Resource::resourceType)).setter(Resource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(Resource.getter(Resource::service)).setter(Resource.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Instant> LAST_REPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastReportedAt").getter(Resource.getter(Resource::lastReportedAt)).setter(Resource.setter(Builder::lastReportedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReportedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<ResourceProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(Resource.getter(Resource::properties)).setter(Resource.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OWNING_ACCOUNT_ID_FIELD, REGION_FIELD, RESOURCE_TYPE_FIELD, SERVICE_FIELD, LAST_REPORTED_AT_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String owningAccountId;
    private final String region;
    private final String resourceType;
    private final String service;
    private final Instant lastReportedAt;
    private final List<ResourceProperty> properties;

    private Resource(BuilderImpl builder) {
        this.arn = builder.arn;
        this.owningAccountId = builder.owningAccountId;
        this.region = builder.region;
        this.resourceType = builder.resourceType;
        this.service = builder.service;
        this.lastReportedAt = builder.lastReportedAt;
        this.properties = builder.properties;
    }

    public final String arn() {
        return this.arn;
    }

    public final String owningAccountId() {
        return this.owningAccountId;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String service() {
        return this.service;
    }

    public final Instant lastReportedAt() {
        return this.lastReportedAt;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<ResourceProperty> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastReportedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.owningAccountId(), other.owningAccountId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.lastReportedAt(), other.lastReportedAt()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Arn", (Object)this.arn()).add("OwningAccountId", (Object)this.owningAccountId()).add("Region", (Object)this.region()).add("ResourceType", (Object)this.resourceType()).add("Service", (Object)this.service()).add("LastReportedAt", (Object)this.lastReportedAt()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OwningAccountId": {
                return Optional.ofNullable(clazz.cast(this.owningAccountId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "LastReportedAt": {
                return Optional.ofNullable(clazz.cast(this.lastReportedAt()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("OwningAccountId", OWNING_ACCOUNT_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("LastReportedAt", LAST_REPORTED_AT_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String owningAccountId;
        private String region;
        private String resourceType;
        private String service;
        private Instant lastReportedAt;
        private List<ResourceProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.arn(model.arn);
            this.owningAccountId(model.owningAccountId);
            this.region(model.region);
            this.resourceType(model.resourceType);
            this.service(model.service);
            this.lastReportedAt(model.lastReportedAt);
            this.properties(model.properties);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwningAccountId() {
            return this.owningAccountId;
        }

        public final void setOwningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
        }

        @Override
        public final Builder owningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Instant getLastReportedAt() {
            return this.lastReportedAt;
        }

        public final void setLastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
        }

        @Override
        public final Builder lastReportedAt(Instant lastReportedAt) {
            this.lastReportedAt = lastReportedAt;
            return this;
        }

        public final List<ResourceProperty.Builder> getProperties() {
            List<ResourceProperty.Builder> result = ResourcePropertyListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<ResourceProperty.BuilderImpl> properties) {
            this.properties = ResourcePropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<ResourceProperty> properties) {
            this.properties = ResourcePropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(ResourceProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<ResourceProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (ResourceProperty)((ResourceProperty.Builder)ResourceProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder arn(String var1);

        public Builder owningAccountId(String var1);

        public Builder region(String var1);

        public Builder resourceType(String var1);

        public Builder service(String var1);

        public Builder lastReportedAt(Instant var1);

        public Builder properties(Collection<ResourceProperty> var1);

        public Builder properties(ResourceProperty ... var1);

        public Builder properties(Consumer<ResourceProperty.Builder> ... var1);
    }
}

