/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourceexplorer2.model.AWSServiceAccessStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrgConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrgConfiguration> {
    private static final SdkField<String> AWS_SERVICE_ACCESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSServiceAccessStatus").getter(OrgConfiguration.getter(OrgConfiguration::awsServiceAccessStatusAsString)).setter(OrgConfiguration.setter(Builder::awsServiceAccessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSServiceAccessStatus").build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLinkedRole").getter(OrgConfiguration.getter(OrgConfiguration::serviceLinkedRole)).setter(OrgConfiguration.setter(Builder::serviceLinkedRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SERVICE_ACCESS_STATUS_FIELD, SERVICE_LINKED_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrgConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsServiceAccessStatus;
    private final String serviceLinkedRole;

    private OrgConfiguration(BuilderImpl builder) {
        this.awsServiceAccessStatus = builder.awsServiceAccessStatus;
        this.serviceLinkedRole = builder.serviceLinkedRole;
    }

    public final AWSServiceAccessStatus awsServiceAccessStatus() {
        return AWSServiceAccessStatus.fromValue(this.awsServiceAccessStatus);
    }

    public final String awsServiceAccessStatusAsString() {
        return this.awsServiceAccessStatus;
    }

    public final String serviceLinkedRole() {
        return this.serviceLinkedRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsServiceAccessStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrgConfiguration)) {
            return false;
        }
        OrgConfiguration other = (OrgConfiguration)obj;
        return Objects.equals(this.awsServiceAccessStatusAsString(), other.awsServiceAccessStatusAsString()) && Objects.equals(this.serviceLinkedRole(), other.serviceLinkedRole());
    }

    public final String toString() {
        return ToString.builder((String)"OrgConfiguration").add("AWSServiceAccessStatus", (Object)this.awsServiceAccessStatusAsString()).add("ServiceLinkedRole", (Object)this.serviceLinkedRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSServiceAccessStatus": {
                return Optional.ofNullable(clazz.cast(this.awsServiceAccessStatusAsString()));
            }
            case "ServiceLinkedRole": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AWSServiceAccessStatus", AWS_SERVICE_ACCESS_STATUS_FIELD);
        map.put("ServiceLinkedRole", SERVICE_LINKED_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrgConfiguration, T> g) {
        return obj -> g.apply((OrgConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsServiceAccessStatus;
        private String serviceLinkedRole;

        private BuilderImpl() {
        }

        private BuilderImpl(OrgConfiguration model) {
            this.awsServiceAccessStatus(model.awsServiceAccessStatus);
            this.serviceLinkedRole(model.serviceLinkedRole);
        }

        public final String getAwsServiceAccessStatus() {
            return this.awsServiceAccessStatus;
        }

        public final void setAwsServiceAccessStatus(String awsServiceAccessStatus) {
            this.awsServiceAccessStatus = awsServiceAccessStatus;
        }

        @Override
        public final Builder awsServiceAccessStatus(String awsServiceAccessStatus) {
            this.awsServiceAccessStatus = awsServiceAccessStatus;
            return this;
        }

        @Override
        public final Builder awsServiceAccessStatus(AWSServiceAccessStatus awsServiceAccessStatus) {
            this.awsServiceAccessStatus(awsServiceAccessStatus == null ? null : awsServiceAccessStatus.toString());
            return this;
        }

        public final String getServiceLinkedRole() {
            return this.serviceLinkedRole;
        }

        public final void setServiceLinkedRole(String serviceLinkedRole) {
            this.serviceLinkedRole = serviceLinkedRole;
        }

        @Override
        public final Builder serviceLinkedRole(String serviceLinkedRole) {
            this.serviceLinkedRole = serviceLinkedRole;
            return this;
        }

        public OrgConfiguration build() {
            return new OrgConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrgConfiguration> {
        public Builder awsServiceAccessStatus(String var1);

        public Builder awsServiceAccessStatus(AWSServiceAccessStatus var1);

        public Builder serviceLinkedRole(String var1);
    }
}

