/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;

public class ListAppComponentRecommendationsIterable
implements SdkIterable<ListAppComponentRecommendationsResponse> {
    private final ResiliencehubClient client;
    private final ListAppComponentRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppComponentRecommendationsIterable(ResiliencehubClient client, ListAppComponentRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppComponentRecommendationsResponseFetcher();
    }

    public Iterator<ListAppComponentRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppComponentRecommendationsResponseFetcher
    implements SyncPageFetcher<ListAppComponentRecommendationsResponse> {
        private ListAppComponentRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppComponentRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppComponentRecommendationsResponse nextPage(ListAppComponentRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListAppComponentRecommendationsIterable.this.client.listAppComponentRecommendations(ListAppComponentRecommendationsIterable.this.firstRequest);
            }
            return ListAppComponentRecommendationsIterable.this.client.listAppComponentRecommendations((ListAppComponentRecommendationsRequest)((Object)ListAppComponentRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

