/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;

public class ListAppComponentCompliancesIterable
implements SdkIterable<ListAppComponentCompliancesResponse> {
    private final ResiliencehubClient client;
    private final ListAppComponentCompliancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppComponentCompliancesIterable(ResiliencehubClient client, ListAppComponentCompliancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppComponentCompliancesResponseFetcher();
    }

    public Iterator<ListAppComponentCompliancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppComponentCompliancesResponseFetcher
    implements SyncPageFetcher<ListAppComponentCompliancesResponse> {
        private ListAppComponentCompliancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppComponentCompliancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppComponentCompliancesResponse nextPage(ListAppComponentCompliancesResponse previousPage) {
            if (previousPage == null) {
                return ListAppComponentCompliancesIterable.this.client.listAppComponentCompliances(ListAppComponentCompliancesIterable.this.firstRequest);
            }
            return ListAppComponentCompliancesIterable.this.client.listAppComponentCompliances((ListAppComponentCompliancesRequest)((Object)ListAppComponentCompliancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

