/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;

public class ListResiliencyPoliciesIterable
implements SdkIterable<ListResiliencyPoliciesResponse> {
    private final ResiliencehubClient client;
    private final ListResiliencyPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResiliencyPoliciesIterable(ResiliencehubClient client, ListResiliencyPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResiliencyPoliciesResponseFetcher();
    }

    public Iterator<ListResiliencyPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResiliencyPoliciesResponseFetcher
    implements SyncPageFetcher<ListResiliencyPoliciesResponse> {
        private ListResiliencyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListResiliencyPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResiliencyPoliciesResponse nextPage(ListResiliencyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListResiliencyPoliciesIterable.this.client.listResiliencyPolicies(ListResiliencyPoliciesIterable.this.firstRequest);
            }
            return ListResiliencyPoliciesIterable.this.client.listResiliencyPolicies((ListResiliencyPoliciesRequest)((Object)ListResiliencyPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

