/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;

public class ListAlarmRecommendationsPublisher
implements SdkPublisher<ListAlarmRecommendationsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAlarmRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAlarmRecommendationsPublisher(ResiliencehubAsyncClient client, ListAlarmRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAlarmRecommendationsPublisher(ResiliencehubAsyncClient client, ListAlarmRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAlarmRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAlarmRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAlarmRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListAlarmRecommendationsResponse> {
        private ListAlarmRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlarmRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAlarmRecommendationsResponse> nextPage(ListAlarmRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListAlarmRecommendationsPublisher.this.client.listAlarmRecommendations(ListAlarmRecommendationsPublisher.this.firstRequest);
            }
            return ListAlarmRecommendationsPublisher.this.client.listAlarmRecommendations((ListAlarmRecommendationsRequest)((Object)ListAlarmRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

