/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSourceType {
    APP_TEMPLATE("AppTemplate"),
    DISCOVERED("Discovered"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSourceType> VALUE_MAP;
    private final String value;

    private ResourceSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSourceType> knownValues() {
        EnumSet<ResourceSourceType> knownValues = EnumSet.allOf(ResourceSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSourceType.class, ResourceSourceType::toString);
    }
}

