/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendationListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlarmRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAlarmRecommendationsResponse> {
    private static final SdkField<List<AlarmRecommendation>> ALARM_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmRecommendations").getter(ListAlarmRecommendationsResponse.getter(ListAlarmRecommendationsResponse::alarmRecommendations)).setter(ListAlarmRecommendationsResponse.setter(Builder::alarmRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAlarmRecommendationsResponse.getter(ListAlarmRecommendationsResponse::nextToken)).setter(ListAlarmRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_RECOMMENDATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAlarmRecommendationsResponse.memberNameToFieldInitializer();
    private final List<AlarmRecommendation> alarmRecommendations;
    private final String nextToken;

    private ListAlarmRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmRecommendations = builder.alarmRecommendations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmRecommendations() {
        return this.alarmRecommendations != null && !(this.alarmRecommendations instanceof SdkAutoConstructList);
    }

    public final List<AlarmRecommendation> alarmRecommendations() {
        return this.alarmRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmRecommendations() ? this.alarmRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmRecommendationsResponse)) {
            return false;
        }
        ListAlarmRecommendationsResponse other = (ListAlarmRecommendationsResponse)((Object)obj);
        return this.hasAlarmRecommendations() == other.hasAlarmRecommendations() && Objects.equals(this.alarmRecommendations(), other.alarmRecommendations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlarmRecommendationsResponse").add("AlarmRecommendations", this.hasAlarmRecommendations() ? this.alarmRecommendations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmRecommendations": {
                return Optional.ofNullable(clazz.cast(this.alarmRecommendations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alarmRecommendations", ALARM_RECOMMENDATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmRecommendationsResponse, T> g) {
        return obj -> g.apply((ListAlarmRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<AlarmRecommendation> alarmRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmRecommendationsResponse model) {
            super(model);
            this.alarmRecommendations(model.alarmRecommendations);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmRecommendation.Builder> getAlarmRecommendations() {
            List<AlarmRecommendation.Builder> result = AlarmRecommendationListCopier.copyToBuilder(this.alarmRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmRecommendations(Collection<AlarmRecommendation.BuilderImpl> alarmRecommendations) {
            this.alarmRecommendations = AlarmRecommendationListCopier.copyFromBuilder(alarmRecommendations);
        }

        @Override
        public final Builder alarmRecommendations(Collection<AlarmRecommendation> alarmRecommendations) {
            this.alarmRecommendations = AlarmRecommendationListCopier.copy(alarmRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmRecommendations(AlarmRecommendation ... alarmRecommendations) {
            this.alarmRecommendations(Arrays.asList(alarmRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmRecommendations(Consumer<AlarmRecommendation.Builder> ... alarmRecommendations) {
            this.alarmRecommendations(Stream.of(alarmRecommendations).map(c -> (AlarmRecommendation)((AlarmRecommendation.Builder)AlarmRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlarmRecommendationsResponse build() {
            return new ListAlarmRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlarmRecommendationsResponse> {
        public Builder alarmRecommendations(Collection<AlarmRecommendation> var1);

        public Builder alarmRecommendations(AlarmRecommendation ... var1);

        public Builder alarmRecommendations(Consumer<AlarmRecommendation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

