/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldAggregationType {
    MIN("Min"),
    MAX("Max"),
    SUM("Sum"),
    AVG("Avg"),
    COUNT("Count"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldAggregationType> VALUE_MAP;
    private final String value;

    private FieldAggregationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldAggregationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldAggregationType> knownValues() {
        EnumSet<FieldAggregationType> knownValues = EnumSet.allOf(FieldAggregationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldAggregationType.class, FieldAggregationType::toString);
    }
}

