/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;

public class ListUnsupportedAppVersionResourcesPublisher
implements SdkPublisher<ListUnsupportedAppVersionResourcesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListUnsupportedAppVersionResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUnsupportedAppVersionResourcesPublisher(ResiliencehubAsyncClient client, ListUnsupportedAppVersionResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUnsupportedAppVersionResourcesPublisher(ResiliencehubAsyncClient client, ListUnsupportedAppVersionResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUnsupportedAppVersionResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUnsupportedAppVersionResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUnsupportedAppVersionResourcesResponseFetcher
    implements AsyncPageFetcher<ListUnsupportedAppVersionResourcesResponse> {
        private ListUnsupportedAppVersionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListUnsupportedAppVersionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUnsupportedAppVersionResourcesResponse> nextPage(ListUnsupportedAppVersionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListUnsupportedAppVersionResourcesPublisher.this.client.listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesPublisher.this.firstRequest);
            }
            return ListUnsupportedAppVersionResourcesPublisher.this.client.listUnsupportedAppVersionResources((ListUnsupportedAppVersionResourcesRequest)((Object)ListUnsupportedAppVersionResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

