/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;

public class ListSopRecommendationsPublisher
implements SdkPublisher<ListSopRecommendationsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListSopRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSopRecommendationsPublisher(ResiliencehubAsyncClient client, ListSopRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSopRecommendationsPublisher(ResiliencehubAsyncClient client, ListSopRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSopRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSopRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSopRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListSopRecommendationsResponse> {
        private ListSopRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSopRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSopRecommendationsResponse> nextPage(ListSopRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListSopRecommendationsPublisher.this.client.listSopRecommendations(ListSopRecommendationsPublisher.this.firstRequest);
            }
            return ListSopRecommendationsPublisher.this.client.listSopRecommendations((ListSopRecommendationsRequest)((Object)ListSopRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

