/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;

public class ListAppVersionResourcesPublisher
implements SdkPublisher<ListAppVersionResourcesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppVersionResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppVersionResourcesPublisher(ResiliencehubAsyncClient client, ListAppVersionResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppVersionResourcesPublisher(ResiliencehubAsyncClient client, ListAppVersionResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppVersionResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppVersionResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppVersionResourcesResponseFetcher
    implements AsyncPageFetcher<ListAppVersionResourcesResponse> {
        private ListAppVersionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppVersionResourcesResponse> nextPage(ListAppVersionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionResourcesPublisher.this.client.listAppVersionResources(ListAppVersionResourcesPublisher.this.firstRequest);
            }
            return ListAppVersionResourcesPublisher.this.client.listAppVersionResources((ListAppVersionResourcesRequest)((Object)ListAppVersionResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

