/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.LogicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.String255ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupingResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupingResource> {
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicalResourceId").getter(GroupingResource.getter(GroupingResource::logicalResourceId)).setter(GroupingResource.setter(Builder::logicalResourceId)).constructor(LogicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()}).build();
    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalResourceId").getter(GroupingResource.getter(GroupingResource::physicalResourceId)).setter(GroupingResource.setter(Builder::physicalResourceId)).constructor(PhysicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(GroupingResource.getter(GroupingResource::resourceName)).setter(GroupingResource.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(GroupingResource.getter(GroupingResource::resourceType)).setter(GroupingResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> SOURCE_APP_COMPONENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceAppComponentIds").getter(GroupingResource.getter(GroupingResource::sourceAppComponentIds)).setter(GroupingResource.setter(Builder::sourceAppComponentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAppComponentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, SOURCE_APP_COMPONENT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupingResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LogicalResourceId logicalResourceId;
    private final PhysicalResourceId physicalResourceId;
    private final String resourceName;
    private final String resourceType;
    private final List<String> sourceAppComponentIds;

    private GroupingResource(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.sourceAppComponentIds = builder.sourceAppComponentIds;
    }

    public final LogicalResourceId logicalResourceId() {
        return this.logicalResourceId;
    }

    public final PhysicalResourceId physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasSourceAppComponentIds() {
        return this.sourceAppComponentIds != null && !(this.sourceAppComponentIds instanceof SdkAutoConstructList);
    }

    public final List<String> sourceAppComponentIds() {
        return this.sourceAppComponentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAppComponentIds() ? this.sourceAppComponentIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingResource)) {
            return false;
        }
        GroupingResource other = (GroupingResource)obj;
        return Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceType(), other.resourceType()) && this.hasSourceAppComponentIds() == other.hasSourceAppComponentIds() && Objects.equals(this.sourceAppComponentIds(), other.sourceAppComponentIds());
    }

    public final String toString() {
        return ToString.builder((String)"GroupingResource").add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceType()).add("SourceAppComponentIds", this.hasSourceAppComponentIds() ? this.sourceAppComponentIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "physicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "sourceAppComponentIds": {
                return Optional.ofNullable(clazz.cast(this.sourceAppComponentIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("physicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("sourceAppComponentIds", SOURCE_APP_COMPONENT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupingResource, T> g) {
        return obj -> g.apply((GroupingResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LogicalResourceId logicalResourceId;
        private PhysicalResourceId physicalResourceId;
        private String resourceName;
        private String resourceType;
        private List<String> sourceAppComponentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingResource model) {
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.sourceAppComponentIds(model.sourceAppComponentIds);
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return this.logicalResourceId != null ? this.logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return this.physicalResourceId != null ? this.physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getSourceAppComponentIds() {
            if (this.sourceAppComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceAppComponentIds;
        }

        public final void setSourceAppComponentIds(Collection<String> sourceAppComponentIds) {
            this.sourceAppComponentIds = String255ListCopier.copy(sourceAppComponentIds);
        }

        @Override
        public final Builder sourceAppComponentIds(Collection<String> sourceAppComponentIds) {
            this.sourceAppComponentIds = String255ListCopier.copy(sourceAppComponentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAppComponentIds(String ... sourceAppComponentIds) {
            this.sourceAppComponentIds(Arrays.asList(sourceAppComponentIds));
            return this;
        }

        public GroupingResource build() {
            return new GroupingResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupingResource> {
        public Builder logicalResourceId(LogicalResourceId var1);

        default public Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return this.logicalResourceId((LogicalResourceId)((LogicalResourceId.Builder)LogicalResourceId.builder().applyMutation(logicalResourceId)).build());
        }

        public Builder physicalResourceId(PhysicalResourceId var1);

        default public Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return this.physicalResourceId((PhysicalResourceId)((PhysicalResourceId.Builder)PhysicalResourceId.builder().applyMutation(physicalResourceId)).build());
        }

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder sourceAppComponentIds(Collection<String> var1);

        public Builder sourceAppComponentIds(String ... var1);
    }
}

