/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ConfigRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.ConfigRecommendationListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationComplianceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(ComponentRecommendation.getter(ComponentRecommendation::appComponentName)).setter(ComponentRecommendation.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<List<ConfigRecommendation>> CONFIG_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configRecommendations").getter(ComponentRecommendation.getter(ComponentRecommendation::configRecommendations)).setter(ComponentRecommendation.setter(Builder::configRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationStatus").getter(ComponentRecommendation.getter(ComponentRecommendation::recommendationStatusAsString)).setter(ComponentRecommendation.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD, CONFIG_RECOMMENDATIONS_FIELD, RECOMMENDATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appComponentName;
    private final List<ConfigRecommendation> configRecommendations;
    private final String recommendationStatus;

    private ComponentRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.configRecommendations = builder.configRecommendations;
        this.recommendationStatus = builder.recommendationStatus;
    }

    public final String appComponentName() {
        return this.appComponentName;
    }

    public final boolean hasConfigRecommendations() {
        return this.configRecommendations != null && !(this.configRecommendations instanceof SdkAutoConstructList);
    }

    public final List<ConfigRecommendation> configRecommendations() {
        return this.configRecommendations;
    }

    public final RecommendationComplianceStatus recommendationStatus() {
        return RecommendationComplianceStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigRecommendations() ? this.configRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRecommendation)) {
            return false;
        }
        ComponentRecommendation other = (ComponentRecommendation)obj;
        return Objects.equals(this.appComponentName(), other.appComponentName()) && this.hasConfigRecommendations() == other.hasConfigRecommendations() && Objects.equals(this.configRecommendations(), other.configRecommendations()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentRecommendation").add("AppComponentName", (Object)this.appComponentName()).add("ConfigRecommendations", this.hasConfigRecommendations() ? this.configRecommendations() : null).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "configRecommendations": {
                return Optional.ofNullable(clazz.cast(this.configRecommendations()));
            }
            case "recommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appComponentName", APP_COMPONENT_NAME_FIELD);
        map.put("configRecommendations", CONFIG_RECOMMENDATIONS_FIELD);
        map.put("recommendationStatus", RECOMMENDATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentRecommendation, T> g) {
        return obj -> g.apply((ComponentRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentName;
        private List<ConfigRecommendation> configRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String recommendationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentRecommendation model) {
            this.appComponentName(model.appComponentName);
            this.configRecommendations(model.configRecommendations);
            this.recommendationStatus(model.recommendationStatus);
        }

        public final String getAppComponentName() {
            return this.appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final List<ConfigRecommendation.Builder> getConfigRecommendations() {
            List<ConfigRecommendation.Builder> result = ConfigRecommendationListCopier.copyToBuilder(this.configRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigRecommendations(Collection<ConfigRecommendation.BuilderImpl> configRecommendations) {
            this.configRecommendations = ConfigRecommendationListCopier.copyFromBuilder(configRecommendations);
        }

        @Override
        public final Builder configRecommendations(Collection<ConfigRecommendation> configRecommendations) {
            this.configRecommendations = ConfigRecommendationListCopier.copy(configRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRecommendations(ConfigRecommendation ... configRecommendations) {
            this.configRecommendations(Arrays.asList(configRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRecommendations(Consumer<ConfigRecommendation.Builder> ... configRecommendations) {
            this.configRecommendations(Stream.of(configRecommendations).map(c -> (ConfigRecommendation)((ConfigRecommendation.Builder)ConfigRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationComplianceStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public ComponentRecommendation build() {
            return new ComponentRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentRecommendation> {
        public Builder appComponentName(String var1);

        public Builder configRecommendations(Collection<ConfigRecommendation> var1);

        public Builder configRecommendations(ConfigRecommendation ... var1);

        public Builder configRecommendations(Consumer<ConfigRecommendation.Builder> ... var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationComplianceStatus var1);
    }
}

