/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentSummary> {
    private static final SdkField<List<AssessmentRiskRecommendation>> RISK_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("riskRecommendations").getter(AssessmentSummary.getter(AssessmentSummary::riskRecommendations)).setter(AssessmentSummary.setter(Builder::riskRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("riskRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentRiskRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(AssessmentSummary.getter(AssessmentSummary::summary)).setter(AssessmentSummary.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_RECOMMENDATIONS_FIELD, SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AssessmentRiskRecommendation> riskRecommendations;
    private final String summary;

    private AssessmentSummary(BuilderImpl builder) {
        this.riskRecommendations = builder.riskRecommendations;
        this.summary = builder.summary;
    }

    public final boolean hasRiskRecommendations() {
        return this.riskRecommendations != null && !(this.riskRecommendations instanceof SdkAutoConstructList);
    }

    public final List<AssessmentRiskRecommendation> riskRecommendations() {
        return this.riskRecommendations;
    }

    public final String summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskRecommendations() ? this.riskRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentSummary)) {
            return false;
        }
        AssessmentSummary other = (AssessmentSummary)obj;
        return this.hasRiskRecommendations() == other.hasRiskRecommendations() && Objects.equals(this.riskRecommendations(), other.riskRecommendations()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentSummary").add("RiskRecommendations", this.hasRiskRecommendations() ? this.riskRecommendations() : null).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "riskRecommendations": {
                return Optional.ofNullable(clazz.cast(this.riskRecommendations()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("riskRecommendations", RISK_RECOMMENDATIONS_FIELD);
        map.put("summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentSummary, T> g) {
        return obj -> g.apply((AssessmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssessmentRiskRecommendation> riskRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String summary;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentSummary model) {
            this.riskRecommendations(model.riskRecommendations);
            this.summary(model.summary);
        }

        public final List<AssessmentRiskRecommendation.Builder> getRiskRecommendations() {
            List<AssessmentRiskRecommendation.Builder> result = AssessmentRiskRecommendationListCopier.copyToBuilder(this.riskRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRiskRecommendations(Collection<AssessmentRiskRecommendation.BuilderImpl> riskRecommendations) {
            this.riskRecommendations = AssessmentRiskRecommendationListCopier.copyFromBuilder(riskRecommendations);
        }

        @Override
        public final Builder riskRecommendations(Collection<AssessmentRiskRecommendation> riskRecommendations) {
            this.riskRecommendations = AssessmentRiskRecommendationListCopier.copy(riskRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder riskRecommendations(AssessmentRiskRecommendation ... riskRecommendations) {
            this.riskRecommendations(Arrays.asList(riskRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder riskRecommendations(Consumer<AssessmentRiskRecommendation.Builder> ... riskRecommendations) {
            this.riskRecommendations(Stream.of(riskRecommendations).map(c -> (AssessmentRiskRecommendation)((AssessmentRiskRecommendation.Builder)AssessmentRiskRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public AssessmentSummary build() {
            return new AssessmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentSummary> {
        public Builder riskRecommendations(Collection<AssessmentRiskRecommendation> var1);

        public Builder riskRecommendations(AssessmentRiskRecommendation ... var1);

        public Builder riskRecommendations(Consumer<AssessmentRiskRecommendation.Builder> ... var1);

        public Builder summary(String var1);
    }
}

