/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRiskRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRiskRecommendation> {
    private static final SdkField<List<String>> APP_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponents").getter(AssessmentRiskRecommendation.getter(AssessmentRiskRecommendation::appComponents)).setter(AssessmentRiskRecommendation.setter(Builder::appComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendation").getter(AssessmentRiskRecommendation.getter(AssessmentRiskRecommendation::recommendation)).setter(AssessmentRiskRecommendation.setter(Builder::recommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<String> RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("risk").getter(AssessmentRiskRecommendation.getter(AssessmentRiskRecommendation::risk)).setter(AssessmentRiskRecommendation.setter(Builder::risk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("risk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENTS_FIELD, RECOMMENDATION_FIELD, RISK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentRiskRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> appComponents;
    private final String recommendation;
    private final String risk;

    private AssessmentRiskRecommendation(BuilderImpl builder) {
        this.appComponents = builder.appComponents;
        this.recommendation = builder.recommendation;
        this.risk = builder.risk;
    }

    public final boolean hasAppComponents() {
        return this.appComponents != null && !(this.appComponents instanceof SdkAutoConstructList);
    }

    public final List<String> appComponents() {
        return this.appComponents;
    }

    public final String recommendation() {
        return this.recommendation;
    }

    public final String risk() {
        return this.risk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponents() ? this.appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.risk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRiskRecommendation)) {
            return false;
        }
        AssessmentRiskRecommendation other = (AssessmentRiskRecommendation)obj;
        return this.hasAppComponents() == other.hasAppComponents() && Objects.equals(this.appComponents(), other.appComponents()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.risk(), other.risk());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentRiskRecommendation").add("AppComponents", this.hasAppComponents() ? this.appComponents() : null).add("Recommendation", (Object)this.recommendation()).add("Risk", (Object)this.risk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponents": {
                return Optional.ofNullable(clazz.cast(this.appComponents()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "risk": {
                return Optional.ofNullable(clazz.cast(this.risk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appComponents", APP_COMPONENTS_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("risk", RISK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRiskRecommendation, T> g) {
        return obj -> g.apply((AssessmentRiskRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> appComponents = DefaultSdkAutoConstructList.getInstance();
        private String recommendation;
        private String risk;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRiskRecommendation model) {
            this.appComponents(model.appComponents);
            this.recommendation(model.recommendation);
            this.risk(model.risk);
        }

        public final Collection<String> getAppComponents() {
            if (this.appComponents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appComponents;
        }

        public final void setAppComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(String ... appComponents) {
            this.appComponents(Arrays.asList(appComponents));
            return this;
        }

        public final String getRecommendation() {
            return this.recommendation;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final String getRisk() {
            return this.risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        public AssessmentRiskRecommendation build() {
            return new AssessmentRiskRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRiskRecommendation> {
        public Builder appComponents(Collection<String> var1);

        public Builder appComponents(String ... var1);

        public Builder recommendation(String var1);

        public Builder risk(String var1);
    }
}

