/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;

public class ListUnsupportedAppVersionResourcesIterable
implements SdkIterable<ListUnsupportedAppVersionResourcesResponse> {
    private final ResiliencehubClient client;
    private final ListUnsupportedAppVersionResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUnsupportedAppVersionResourcesIterable(ResiliencehubClient client, ListUnsupportedAppVersionResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUnsupportedAppVersionResourcesResponseFetcher();
    }

    public Iterator<ListUnsupportedAppVersionResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUnsupportedAppVersionResourcesResponseFetcher
    implements SyncPageFetcher<ListUnsupportedAppVersionResourcesResponse> {
        private ListUnsupportedAppVersionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListUnsupportedAppVersionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUnsupportedAppVersionResourcesResponse nextPage(ListUnsupportedAppVersionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListUnsupportedAppVersionResourcesIterable.this.client.listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesIterable.this.firstRequest);
            }
            return ListUnsupportedAppVersionResourcesIterable.this.client.listUnsupportedAppVersionResources((ListUnsupportedAppVersionResourcesRequest)((Object)ListUnsupportedAppVersionResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

