/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AdditionalInfoMapCopier;
import software.amazon.awssdk.services.resiliencehub.model.AppComponent;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentListCopier;
import software.amazon.awssdk.services.resiliencehub.model.LogicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.ResourceSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalResource> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(PhysicalResource.getter(PhysicalResource::additionalInfo)).setter(PhysicalResource.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<AppComponent>> APP_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponents").getter(PhysicalResource.getter(PhysicalResource::appComponents)).setter(PhysicalResource.setter(Builder::appComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excluded").getter(PhysicalResource.getter(PhysicalResource::excluded)).setter(PhysicalResource.setter(Builder::excluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()}).build();
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicalResourceId").getter(PhysicalResource.getter(PhysicalResource::logicalResourceId)).setter(PhysicalResource.setter(Builder::logicalResourceId)).constructor(LogicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()}).build();
    private static final SdkField<String> PARENT_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentResourceName").getter(PhysicalResource.getter(PhysicalResource::parentResourceName)).setter(PhysicalResource.setter(Builder::parentResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentResourceName").build()}).build();
    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalResourceId").getter(PhysicalResource.getter(PhysicalResource::physicalResourceId)).setter(PhysicalResource.setter(Builder::physicalResourceId)).constructor(PhysicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(PhysicalResource.getter(PhysicalResource::resourceName)).setter(PhysicalResource.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(PhysicalResource.getter(PhysicalResource::resourceType)).setter(PhysicalResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(PhysicalResource.getter(PhysicalResource::sourceTypeAsString)).setter(PhysicalResource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD, APP_COMPONENTS_FIELD, EXCLUDED_FIELD, LOGICAL_RESOURCE_ID_FIELD, PARENT_RESOURCE_NAME_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhysicalResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> additionalInfo;
    private final List<AppComponent> appComponents;
    private final Boolean excluded;
    private final LogicalResourceId logicalResourceId;
    private final String parentResourceName;
    private final PhysicalResourceId physicalResourceId;
    private final String resourceName;
    private final String resourceType;
    private final String sourceType;

    private PhysicalResource(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.appComponents = builder.appComponents;
        this.excluded = builder.excluded;
        this.logicalResourceId = builder.logicalResourceId;
        this.parentResourceName = builder.parentResourceName;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.sourceType = builder.sourceType;
    }

    public final boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> additionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasAppComponents() {
        return this.appComponents != null && !(this.appComponents instanceof SdkAutoConstructList);
    }

    public final List<AppComponent> appComponents() {
        return this.appComponents;
    }

    public final Boolean excluded() {
        return this.excluded;
    }

    public final LogicalResourceId logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String parentResourceName() {
        return this.parentResourceName;
    }

    public final PhysicalResourceId physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final ResourceSourceType sourceType() {
        return ResourceSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponents() ? this.appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.excluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalResource)) {
            return false;
        }
        PhysicalResource other = (PhysicalResource)obj;
        return this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo()) && this.hasAppComponents() == other.hasAppComponents() && Objects.equals(this.appComponents(), other.appComponents()) && Objects.equals(this.excluded(), other.excluded()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.parentResourceName(), other.parentResourceName()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalResource").add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).add("AppComponents", this.hasAppComponents() ? this.appComponents() : null).add("Excluded", (Object)this.excluded()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("ParentResourceName", (Object)this.parentResourceName()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceType()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "appComponents": {
                return Optional.ofNullable(clazz.cast(this.appComponents()));
            }
            case "excluded": {
                return Optional.ofNullable(clazz.cast(this.excluded()));
            }
            case "logicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "parentResourceName": {
                return Optional.ofNullable(clazz.cast(this.parentResourceName()));
            }
            case "physicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("appComponents", APP_COMPONENTS_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("logicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("parentResourceName", PARENT_RESOURCE_NAME_FIELD);
        map.put("physicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("sourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalResource, T> g) {
        return obj -> g.apply((PhysicalResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();
        private List<AppComponent> appComponents = DefaultSdkAutoConstructList.getInstance();
        private Boolean excluded;
        private LogicalResourceId logicalResourceId;
        private String parentResourceName;
        private PhysicalResourceId physicalResourceId;
        private String resourceName;
        private String resourceType;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalResource model) {
            this.additionalInfo(model.additionalInfo);
            this.appComponents(model.appComponents);
            this.excluded(model.excluded);
            this.logicalResourceId(model.logicalResourceId);
            this.parentResourceName(model.parentResourceName);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.sourceType(model.sourceType);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final List<AppComponent.Builder> getAppComponents() {
            List<AppComponent.Builder> result = AppComponentListCopier.copyToBuilder(this.appComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppComponents(Collection<AppComponent.BuilderImpl> appComponents) {
            this.appComponents = AppComponentListCopier.copyFromBuilder(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<AppComponent> appComponents) {
            this.appComponents = AppComponentListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(AppComponent ... appComponents) {
            this.appComponents(Arrays.asList(appComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(Consumer<AppComponent.Builder> ... appComponents) {
            this.appComponents(Stream.of(appComponents).map(c -> (AppComponent)((AppComponent.Builder)AppComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getExcluded() {
            return this.excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return this.logicalResourceId != null ? this.logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getParentResourceName() {
            return this.parentResourceName;
        }

        public final void setParentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
        }

        @Override
        public final Builder parentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return this.physicalResourceId != null ? this.physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ResourceSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public PhysicalResource build() {
            return new PhysicalResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalResource> {
        public Builder additionalInfo(Map<String, ? extends Collection<String>> var1);

        public Builder appComponents(Collection<AppComponent> var1);

        public Builder appComponents(AppComponent ... var1);

        public Builder appComponents(Consumer<AppComponent.Builder> ... var1);

        public Builder excluded(Boolean var1);

        public Builder logicalResourceId(LogicalResourceId var1);

        default public Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return this.logicalResourceId((LogicalResourceId)((LogicalResourceId.Builder)LogicalResourceId.builder().applyMutation(logicalResourceId)).build());
        }

        public Builder parentResourceName(String var1);

        public Builder physicalResourceId(PhysicalResourceId var1);

        default public Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return this.physicalResourceId((PhysicalResourceId)((PhysicalResourceId.Builder)PhysicalResourceId.builder().applyMutation(physicalResourceId)).build());
        }

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(ResourceSourceType var1);
    }
}

