/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourcesGroupingRecGenStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceGroupingRecommendationTaskResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DescribeResourceGroupingRecommendationTaskResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeResourceGroupingRecommendationTaskResponse.getter(DescribeResourceGroupingRecommendationTaskResponse::errorMessage)).setter(DescribeResourceGroupingRecommendationTaskResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> GROUPING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupingId").getter(DescribeResourceGroupingRecommendationTaskResponse.getter(DescribeResourceGroupingRecommendationTaskResponse::groupingId)).setter(DescribeResourceGroupingRecommendationTaskResponse.setter(Builder::groupingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeResourceGroupingRecommendationTaskResponse.getter(DescribeResourceGroupingRecommendationTaskResponse::statusAsString)).setter(DescribeResourceGroupingRecommendationTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, GROUPING_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeResourceGroupingRecommendationTaskResponse.memberNameToFieldInitializer();
    private final String errorMessage;
    private final String groupingId;
    private final String status;

    private DescribeResourceGroupingRecommendationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.groupingId = builder.groupingId;
        this.status = builder.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String groupingId() {
        return this.groupingId;
    }

    public final ResourcesGroupingRecGenStatusType status() {
        return ResourcesGroupingRecGenStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupingRecommendationTaskResponse)) {
            return false;
        }
        DescribeResourceGroupingRecommendationTaskResponse other = (DescribeResourceGroupingRecommendationTaskResponse)((Object)obj);
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.groupingId(), other.groupingId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceGroupingRecommendationTaskResponse").add("ErrorMessage", (Object)this.errorMessage()).add("GroupingId", (Object)this.groupingId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "groupingId": {
                return Optional.ofNullable(clazz.cast(this.groupingId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("groupingId", GROUPING_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupingRecommendationTaskResponse, T> g) {
        return obj -> g.apply((DescribeResourceGroupingRecommendationTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String errorMessage;
        private String groupingId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupingRecommendationTaskResponse model) {
            super(model);
            this.errorMessage(model.errorMessage);
            this.groupingId(model.groupingId);
            this.status(model.status);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getGroupingId() {
            return this.groupingId;
        }

        public final void setGroupingId(String groupingId) {
            this.groupingId = groupingId;
        }

        @Override
        public final Builder groupingId(String groupingId) {
            this.groupingId = groupingId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourcesGroupingRecGenStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeResourceGroupingRecommendationTaskResponse build() {
            return new DescribeResourceGroupingRecommendationTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceGroupingRecommendationTaskResponse> {
        public Builder errorMessage(String var1);

        public Builder groupingId(String var1);

        public Builder status(String var1);

        public Builder status(ResourcesGroupingRecGenStatusType var1);
    }
}

