/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.services.repostspace.model.SupportedEmailDomainsParameters;
import software.amazon.awssdk.services.repostspace.model.TierLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSpaceRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, UpdateSpaceRequest> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::spaceId)).setter(UpdateSpaceRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::description)).setter(UpdateSpaceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::tierAsString)).setter(UpdateSpaceRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::roleArn)).setter(UpdateSpaceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<SupportedEmailDomainsParameters> SUPPORTED_EMAIL_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supportedEmailDomains").getter(UpdateSpaceRequest.getter(UpdateSpaceRequest::supportedEmailDomains)).setter(UpdateSpaceRequest.setter(Builder::supportedEmailDomains)).constructor(SupportedEmailDomainsParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEmailDomains").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD, DESCRIPTION_FIELD, TIER_FIELD, ROLE_ARN_FIELD, SUPPORTED_EMAIL_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSpaceRequest.memberNameToFieldInitializer();
    private final String spaceId;
    private final String description;
    private final String tier;
    private final String roleArn;
    private final SupportedEmailDomainsParameters supportedEmailDomains;

    private UpdateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.description = builder.description;
        this.tier = builder.tier;
        this.roleArn = builder.roleArn;
        this.supportedEmailDomains = builder.supportedEmailDomains;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String description() {
        return this.description;
    }

    public final TierLevel tier() {
        return TierLevel.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final SupportedEmailDomainsParameters supportedEmailDomains() {
        return this.supportedEmailDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEmailDomains());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpaceRequest)) {
            return false;
        }
        UpdateSpaceRequest other = (UpdateSpaceRequest)((Object)obj);
        return Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.supportedEmailDomains(), other.supportedEmailDomains());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSpaceRequest").add("SpaceId", (Object)this.spaceId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Tier", (Object)this.tierAsString()).add("RoleArn", (Object)this.roleArn()).add("SupportedEmailDomains", (Object)this.supportedEmailDomains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "supportedEmailDomains": {
                return Optional.ofNullable(clazz.cast(this.supportedEmailDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("supportedEmailDomains", SUPPORTED_EMAIL_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpaceRequest, T> g) {
        return obj -> g.apply((UpdateSpaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private String spaceId;
        private String description;
        private String tier;
        private String roleArn;
        private SupportedEmailDomainsParameters supportedEmailDomains;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpaceRequest model) {
            super(model);
            this.spaceId(model.spaceId);
            this.description(model.description);
            this.tier(model.tier);
            this.roleArn(model.roleArn);
            this.supportedEmailDomains(model.supportedEmailDomains);
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final SupportedEmailDomainsParameters.Builder getSupportedEmailDomains() {
            return this.supportedEmailDomains != null ? this.supportedEmailDomains.toBuilder() : null;
        }

        public final void setSupportedEmailDomains(SupportedEmailDomainsParameters.BuilderImpl supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains != null ? supportedEmailDomains.build() : null;
        }

        @Override
        public final Builder supportedEmailDomains(SupportedEmailDomainsParameters supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpaceRequest build() {
            return new UpdateSpaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSpaceRequest> {
        public Builder spaceId(String var1);

        public Builder description(String var1);

        public Builder tier(String var1);

        public Builder tier(TierLevel var1);

        public Builder roleArn(String var1);

        public Builder supportedEmailDomains(SupportedEmailDomainsParameters var1);

        default public Builder supportedEmailDomains(Consumer<SupportedEmailDomainsParameters.Builder> supportedEmailDomains) {
            return this.supportedEmailDomains((SupportedEmailDomainsParameters)((SupportedEmailDomainsParameters.Builder)SupportedEmailDomainsParameters.builder().applyMutation(supportedEmailDomains)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

