/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.repostspace.model.ConfigurationStatus;
import software.amazon.awssdk.services.repostspace.model.GroupAdminsCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.services.repostspace.model.Role;
import software.amazon.awssdk.services.repostspace.model.RolesCopier;
import software.amazon.awssdk.services.repostspace.model.SupportedEmailDomainsStatus;
import software.amazon.awssdk.services.repostspace.model.TierLevel;
import software.amazon.awssdk.services.repostspace.model.UserAdminsCopier;
import software.amazon.awssdk.services.repostspace.model.VanityDomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSpaceResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, GetSpaceResponse> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(GetSpaceResponse.getter(GetSpaceResponse::spaceId)).setter(GetSpaceResponse.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSpaceResponse.getter(GetSpaceResponse::arn)).setter(GetSpaceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetSpaceResponse.getter(GetSpaceResponse::name)).setter(GetSpaceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSpaceResponse.getter(GetSpaceResponse::status)).setter(GetSpaceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationStatus").getter(GetSpaceResponse.getter(GetSpaceResponse::configurationStatusAsString)).setter(GetSpaceResponse.setter(Builder::configurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(GetSpaceResponse.getter(GetSpaceResponse::clientId)).setter(GetSpaceResponse.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityStoreId").getter(GetSpaceResponse.getter(GetSpaceResponse::identityStoreId)).setter(GetSpaceResponse.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(GetSpaceResponse.getter(GetSpaceResponse::applicationArn)).setter(GetSpaceResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSpaceResponse.getter(GetSpaceResponse::description)).setter(GetSpaceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomainStatus").getter(GetSpaceResponse.getter(GetSpaceResponse::vanityDomainStatusAsString)).setter(GetSpaceResponse.setter(Builder::vanityDomainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomainStatus").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomain").getter(GetSpaceResponse.getter(GetSpaceResponse::vanityDomain)).setter(GetSpaceResponse.setter(Builder::vanityDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomain").build()}).build();
    private static final SdkField<String> RANDOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomDomain").getter(GetSpaceResponse.getter(GetSpaceResponse::randomDomain)).setter(GetSpaceResponse.setter(Builder::randomDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomDomain").build()}).build();
    private static final SdkField<String> CUSTOMER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerRoleArn").getter(GetSpaceResponse.getter(GetSpaceResponse::customerRoleArn)).setter(GetSpaceResponse.setter(Builder::customerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRoleArn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createDateTime").getter(GetSpaceResponse.getter(GetSpaceResponse::createDateTime)).setter(GetSpaceResponse.setter(Builder::createDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deleteDateTime").getter(GetSpaceResponse.getter(GetSpaceResponse::deleteDateTime)).setter(GetSpaceResponse.setter(Builder::deleteDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(GetSpaceResponse.getter(GetSpaceResponse::tierAsString)).setter(GetSpaceResponse.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<Long> STORAGE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageLimit").getter(GetSpaceResponse.getter(GetSpaceResponse::storageLimit)).setter(GetSpaceResponse.setter(Builder::storageLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLimit").build()}).build();
    private static final SdkField<List<String>> USER_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAdmins").getter(GetSpaceResponse.getter(GetSpaceResponse::userAdmins)).setter(GetSpaceResponse.setter(Builder::userAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupAdmins").getter(GetSpaceResponse.getter(GetSpaceResponse::groupAdmins)).setter(GetSpaceResponse.setter(Builder::groupAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("roles").getter(GetSpaceResponse.getter(GetSpaceResponse::rolesAsStrings)).setter(GetSpaceResponse.setter(Builder::rolesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userKMSKey").getter(GetSpaceResponse.getter(GetSpaceResponse::userKMSKey)).setter(GetSpaceResponse.setter(Builder::userKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("userCount").getter(GetSpaceResponse.getter(GetSpaceResponse::userCount)).setter(GetSpaceResponse.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()}).build();
    private static final SdkField<Long> CONTENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("contentSize").getter(GetSpaceResponse.getter(GetSpaceResponse::contentSize)).setter(GetSpaceResponse.setter(Builder::contentSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSize").build()}).build();
    private static final SdkField<SupportedEmailDomainsStatus> SUPPORTED_EMAIL_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supportedEmailDomains").getter(GetSpaceResponse.getter(GetSpaceResponse::supportedEmailDomains)).setter(GetSpaceResponse.setter(Builder::supportedEmailDomains)).constructor(SupportedEmailDomainsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEmailDomains").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, CONFIGURATION_STATUS_FIELD, CLIENT_ID_FIELD, IDENTITY_STORE_ID_FIELD, APPLICATION_ARN_FIELD, DESCRIPTION_FIELD, VANITY_DOMAIN_STATUS_FIELD, VANITY_DOMAIN_FIELD, RANDOM_DOMAIN_FIELD, CUSTOMER_ROLE_ARN_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD, TIER_FIELD, STORAGE_LIMIT_FIELD, USER_ADMINS_FIELD, GROUP_ADMINS_FIELD, ROLES_FIELD, USER_KMS_KEY_FIELD, USER_COUNT_FIELD, CONTENT_SIZE_FIELD, SUPPORTED_EMAIL_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSpaceResponse.memberNameToFieldInitializer();
    private final String spaceId;
    private final String arn;
    private final String name;
    private final String status;
    private final String configurationStatus;
    private final String clientId;
    private final String identityStoreId;
    private final String applicationArn;
    private final String description;
    private final String vanityDomainStatus;
    private final String vanityDomain;
    private final String randomDomain;
    private final String customerRoleArn;
    private final Instant createDateTime;
    private final Instant deleteDateTime;
    private final String tier;
    private final Long storageLimit;
    private final List<String> userAdmins;
    private final List<String> groupAdmins;
    private final Map<String, List<String>> roles;
    private final String userKMSKey;
    private final Integer userCount;
    private final Long contentSize;
    private final SupportedEmailDomainsStatus supportedEmailDomains;

    private GetSpaceResponse(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.configurationStatus = builder.configurationStatus;
        this.clientId = builder.clientId;
        this.identityStoreId = builder.identityStoreId;
        this.applicationArn = builder.applicationArn;
        this.description = builder.description;
        this.vanityDomainStatus = builder.vanityDomainStatus;
        this.vanityDomain = builder.vanityDomain;
        this.randomDomain = builder.randomDomain;
        this.customerRoleArn = builder.customerRoleArn;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.tier = builder.tier;
        this.storageLimit = builder.storageLimit;
        this.userAdmins = builder.userAdmins;
        this.groupAdmins = builder.groupAdmins;
        this.roles = builder.roles;
        this.userKMSKey = builder.userKMSKey;
        this.userCount = builder.userCount;
        this.contentSize = builder.contentSize;
        this.supportedEmailDomains = builder.supportedEmailDomains;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final ConfigurationStatus configurationStatus() {
        return ConfigurationStatus.fromValue(this.configurationStatus);
    }

    public final String configurationStatusAsString() {
        return this.configurationStatus;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String description() {
        return this.description;
    }

    public final VanityDomainStatus vanityDomainStatus() {
        return VanityDomainStatus.fromValue(this.vanityDomainStatus);
    }

    public final String vanityDomainStatusAsString() {
        return this.vanityDomainStatus;
    }

    public final String vanityDomain() {
        return this.vanityDomain;
    }

    public final String randomDomain() {
        return this.randomDomain;
    }

    public final String customerRoleArn() {
        return this.customerRoleArn;
    }

    public final Instant createDateTime() {
        return this.createDateTime;
    }

    public final Instant deleteDateTime() {
        return this.deleteDateTime;
    }

    public final TierLevel tier() {
        return TierLevel.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Long storageLimit() {
        return this.storageLimit;
    }

    @Deprecated
    public final boolean hasUserAdmins() {
        return this.userAdmins != null && !(this.userAdmins instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> userAdmins() {
        return this.userAdmins;
    }

    @Deprecated
    public final boolean hasGroupAdmins() {
        return this.groupAdmins != null && !(this.groupAdmins instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> groupAdmins() {
        return this.groupAdmins;
    }

    public final Map<String, List<Role>> roles() {
        return RolesCopier.copyStringToEnum(this.roles);
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> rolesAsStrings() {
        return this.roles;
    }

    public final String userKMSKey() {
        return this.userKMSKey;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final Long contentSize() {
        return this.contentSize;
    }

    public final SupportedEmailDomainsStatus supportedEmailDomains() {
        return this.supportedEmailDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAdmins() ? this.userAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupAdmins() ? this.groupAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.rolesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEmailDomains());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpaceResponse)) {
            return false;
        }
        GetSpaceResponse other = (GetSpaceResponse)((Object)obj);
        return Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.configurationStatusAsString(), other.configurationStatusAsString()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vanityDomainStatusAsString(), other.vanityDomainStatusAsString()) && Objects.equals(this.vanityDomain(), other.vanityDomain()) && Objects.equals(this.randomDomain(), other.randomDomain()) && Objects.equals(this.customerRoleArn(), other.customerRoleArn()) && Objects.equals(this.createDateTime(), other.createDateTime()) && Objects.equals(this.deleteDateTime(), other.deleteDateTime()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.storageLimit(), other.storageLimit()) && this.hasUserAdmins() == other.hasUserAdmins() && Objects.equals(this.userAdmins(), other.userAdmins()) && this.hasGroupAdmins() == other.hasGroupAdmins() && Objects.equals(this.groupAdmins(), other.groupAdmins()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.rolesAsStrings(), other.rolesAsStrings()) && Objects.equals(this.userKMSKey(), other.userKMSKey()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.contentSize(), other.contentSize()) && Objects.equals(this.supportedEmailDomains(), other.supportedEmailDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GetSpaceResponse").add("SpaceId", (Object)this.spaceId()).add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.status()).add("ConfigurationStatus", (Object)this.configurationStatusAsString()).add("ClientId", (Object)this.clientId()).add("IdentityStoreId", (Object)this.identityStoreId()).add("ApplicationArn", (Object)this.applicationArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("VanityDomainStatus", (Object)this.vanityDomainStatusAsString()).add("VanityDomain", (Object)this.vanityDomain()).add("RandomDomain", (Object)this.randomDomain()).add("CustomerRoleArn", (Object)this.customerRoleArn()).add("CreateDateTime", (Object)this.createDateTime()).add("DeleteDateTime", (Object)this.deleteDateTime()).add("Tier", (Object)this.tierAsString()).add("StorageLimit", (Object)this.storageLimit()).add("UserAdmins", this.hasUserAdmins() ? this.userAdmins() : null).add("GroupAdmins", this.hasGroupAdmins() ? this.groupAdmins() : null).add("Roles", this.hasRoles() ? this.rolesAsStrings() : null).add("UserKMSKey", (Object)this.userKMSKey()).add("UserCount", (Object)this.userCount()).add("ContentSize", (Object)this.contentSize()).add("SupportedEmailDomains", (Object)this.supportedEmailDomains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatusAsString()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "identityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "vanityDomainStatus": {
                return Optional.ofNullable(clazz.cast(this.vanityDomainStatusAsString()));
            }
            case "vanityDomain": {
                return Optional.ofNullable(clazz.cast(this.vanityDomain()));
            }
            case "randomDomain": {
                return Optional.ofNullable(clazz.cast(this.randomDomain()));
            }
            case "customerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customerRoleArn()));
            }
            case "createDateTime": {
                return Optional.ofNullable(clazz.cast(this.createDateTime()));
            }
            case "deleteDateTime": {
                return Optional.ofNullable(clazz.cast(this.deleteDateTime()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "storageLimit": {
                return Optional.ofNullable(clazz.cast(this.storageLimit()));
            }
            case "userAdmins": {
                return Optional.ofNullable(clazz.cast(this.userAdmins()));
            }
            case "groupAdmins": {
                return Optional.ofNullable(clazz.cast(this.groupAdmins()));
            }
            case "roles": {
                return Optional.ofNullable(clazz.cast(this.rolesAsStrings()));
            }
            case "userKMSKey": {
                return Optional.ofNullable(clazz.cast(this.userKMSKey()));
            }
            case "userCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "contentSize": {
                return Optional.ofNullable(clazz.cast(this.contentSize()));
            }
            case "supportedEmailDomains": {
                return Optional.ofNullable(clazz.cast(this.supportedEmailDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("identityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("vanityDomainStatus", VANITY_DOMAIN_STATUS_FIELD);
        map.put("vanityDomain", VANITY_DOMAIN_FIELD);
        map.put("randomDomain", RANDOM_DOMAIN_FIELD);
        map.put("customerRoleArn", CUSTOMER_ROLE_ARN_FIELD);
        map.put("createDateTime", CREATE_DATE_TIME_FIELD);
        map.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("storageLimit", STORAGE_LIMIT_FIELD);
        map.put("userAdmins", USER_ADMINS_FIELD);
        map.put("groupAdmins", GROUP_ADMINS_FIELD);
        map.put("roles", ROLES_FIELD);
        map.put("userKMSKey", USER_KMS_KEY_FIELD);
        map.put("userCount", USER_COUNT_FIELD);
        map.put("contentSize", CONTENT_SIZE_FIELD);
        map.put("supportedEmailDomains", SUPPORTED_EMAIL_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSpaceResponse, T> g) {
        return obj -> g.apply((GetSpaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private String spaceId;
        private String arn;
        private String name;
        private String status;
        private String configurationStatus;
        private String clientId;
        private String identityStoreId;
        private String applicationArn;
        private String description;
        private String vanityDomainStatus;
        private String vanityDomain;
        private String randomDomain;
        private String customerRoleArn;
        private Instant createDateTime;
        private Instant deleteDateTime;
        private String tier;
        private Long storageLimit;
        private List<String> userAdmins = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupAdmins = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> roles = DefaultSdkAutoConstructMap.getInstance();
        private String userKMSKey;
        private Integer userCount;
        private Long contentSize;
        private SupportedEmailDomainsStatus supportedEmailDomains;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpaceResponse model) {
            super(model);
            this.spaceId(model.spaceId);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.configurationStatus(model.configurationStatus);
            this.clientId(model.clientId);
            this.identityStoreId(model.identityStoreId);
            this.applicationArn(model.applicationArn);
            this.description(model.description);
            this.vanityDomainStatus(model.vanityDomainStatus);
            this.vanityDomain(model.vanityDomain);
            this.randomDomain(model.randomDomain);
            this.customerRoleArn(model.customerRoleArn);
            this.createDateTime(model.createDateTime);
            this.deleteDateTime(model.deleteDateTime);
            this.tier(model.tier);
            this.storageLimit(model.storageLimit);
            this.userAdmins(model.userAdmins);
            this.groupAdmins(model.groupAdmins);
            this.rolesWithStrings(model.roles);
            this.userKMSKey(model.userKMSKey);
            this.userCount(model.userCount);
            this.contentSize(model.contentSize);
            this.supportedEmailDomains(model.supportedEmailDomains);
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getConfigurationStatus() {
            return this.configurationStatus;
        }

        public final void setConfigurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
        }

        @Override
        public final Builder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus(configurationStatus == null ? null : configurationStatus.toString());
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVanityDomainStatus() {
            return this.vanityDomainStatus;
        }

        public final void setVanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
        }

        @Override
        public final Builder vanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
            return this;
        }

        @Override
        public final Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus) {
            this.vanityDomainStatus(vanityDomainStatus == null ? null : vanityDomainStatus.toString());
            return this;
        }

        public final String getVanityDomain() {
            return this.vanityDomain;
        }

        public final void setVanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
        }

        @Override
        public final Builder vanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
            return this;
        }

        public final String getRandomDomain() {
            return this.randomDomain;
        }

        public final void setRandomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
        }

        @Override
        public final Builder randomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
            return this;
        }

        public final String getCustomerRoleArn() {
            return this.customerRoleArn;
        }

        public final void setCustomerRoleArn(String customerRoleArn) {
            this.customerRoleArn = customerRoleArn;
        }

        @Override
        public final Builder customerRoleArn(String customerRoleArn) {
            this.customerRoleArn = customerRoleArn;
            return this;
        }

        public final Instant getCreateDateTime() {
            return this.createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return this.deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Long getStorageLimit() {
            return this.storageLimit;
        }

        public final void setStorageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        @Deprecated
        public final Collection<String> getUserAdmins() {
            if (this.userAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userAdmins;
        }

        @Deprecated
        public final void setUserAdmins(Collection<String> userAdmins) {
            this.userAdmins = UserAdminsCopier.copy(userAdmins);
        }

        @Override
        @Deprecated
        public final Builder userAdmins(Collection<String> userAdmins) {
            this.userAdmins = UserAdminsCopier.copy(userAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder userAdmins(String ... userAdmins) {
            this.userAdmins(Arrays.asList(userAdmins));
            return this;
        }

        @Deprecated
        public final Collection<String> getGroupAdmins() {
            if (this.groupAdmins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupAdmins;
        }

        @Deprecated
        public final void setGroupAdmins(Collection<String> groupAdmins) {
            this.groupAdmins = GroupAdminsCopier.copy(groupAdmins);
        }

        @Override
        @Deprecated
        public final Builder groupAdmins(Collection<String> groupAdmins) {
            this.groupAdmins = GroupAdminsCopier.copy(groupAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder groupAdmins(String ... groupAdmins) {
            this.groupAdmins(Arrays.asList(groupAdmins));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getRoles() {
            if (this.roles instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.roles;
        }

        public final void setRoles(Map<String, ? extends Collection<String>> roles) {
            this.roles = RolesCopier.copy(roles);
        }

        @Override
        public final Builder rolesWithStrings(Map<String, ? extends Collection<String>> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        public final String getUserKMSKey() {
            return this.userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Long getContentSize() {
            return this.contentSize;
        }

        public final void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }

        @Override
        public final Builder contentSize(Long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public final SupportedEmailDomainsStatus.Builder getSupportedEmailDomains() {
            return this.supportedEmailDomains != null ? this.supportedEmailDomains.toBuilder() : null;
        }

        public final void setSupportedEmailDomains(SupportedEmailDomainsStatus.BuilderImpl supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains != null ? supportedEmailDomains.build() : null;
        }

        @Override
        public final Builder supportedEmailDomains(SupportedEmailDomainsStatus supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains;
            return this;
        }

        @Override
        public GetSpaceResponse build() {
            return new GetSpaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSpaceResponse> {
        public Builder spaceId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder configurationStatus(String var1);

        public Builder configurationStatus(ConfigurationStatus var1);

        public Builder clientId(String var1);

        public Builder identityStoreId(String var1);

        public Builder applicationArn(String var1);

        public Builder description(String var1);

        public Builder vanityDomainStatus(String var1);

        public Builder vanityDomainStatus(VanityDomainStatus var1);

        public Builder vanityDomain(String var1);

        public Builder randomDomain(String var1);

        public Builder customerRoleArn(String var1);

        public Builder createDateTime(Instant var1);

        public Builder deleteDateTime(Instant var1);

        public Builder tier(String var1);

        public Builder tier(TierLevel var1);

        public Builder storageLimit(Long var1);

        @Deprecated
        public Builder userAdmins(Collection<String> var1);

        @Deprecated
        public Builder userAdmins(String ... var1);

        @Deprecated
        public Builder groupAdmins(Collection<String> var1);

        @Deprecated
        public Builder groupAdmins(String ... var1);

        public Builder rolesWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder userKMSKey(String var1);

        public Builder userCount(Integer var1);

        public Builder contentSize(Long var1);

        public Builder supportedEmailDomains(SupportedEmailDomainsStatus var1);

        default public Builder supportedEmailDomains(Consumer<SupportedEmailDomainsStatus.Builder> supportedEmailDomains) {
            return this.supportedEmailDomains((SupportedEmailDomainsStatus)((SupportedEmailDomainsStatus.Builder)SupportedEmailDomainsStatus.builder().applyMutation(supportedEmailDomains)).build());
        }
    }
}

