/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.AccessorIdListCopier;
import software.amazon.awssdk.services.repostspace.model.BatchError;
import software.amazon.awssdk.services.repostspace.model.BatchErrorListCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAddRoleResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, BatchAddRoleResponse> {
    private static final SdkField<List<String>> ADDED_ACCESSOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addedAccessorIds").getter(BatchAddRoleResponse.getter(BatchAddRoleResponse::addedAccessorIds)).setter(BatchAddRoleResponse.setter(Builder::addedAccessorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedAccessorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchAddRoleResponse.getter(BatchAddRoleResponse::errors)).setter(BatchAddRoleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_ACCESSOR_IDS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAddRoleResponse.memberNameToFieldInitializer();
    private final List<String> addedAccessorIds;
    private final List<BatchError> errors;

    private BatchAddRoleResponse(BuilderImpl builder) {
        super(builder);
        this.addedAccessorIds = builder.addedAccessorIds;
        this.errors = builder.errors;
    }

    public final boolean hasAddedAccessorIds() {
        return this.addedAccessorIds != null && !(this.addedAccessorIds instanceof SdkAutoConstructList);
    }

    public final List<String> addedAccessorIds() {
        return this.addedAccessorIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddedAccessorIds() ? this.addedAccessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddRoleResponse)) {
            return false;
        }
        BatchAddRoleResponse other = (BatchAddRoleResponse)((Object)obj);
        return this.hasAddedAccessorIds() == other.hasAddedAccessorIds() && Objects.equals(this.addedAccessorIds(), other.addedAccessorIds()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAddRoleResponse").add("AddedAccessorIds", this.hasAddedAccessorIds() ? this.addedAccessorIds() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addedAccessorIds": {
                return Optional.ofNullable(clazz.cast(this.addedAccessorIds()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addedAccessorIds", ADDED_ACCESSOR_IDS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddRoleResponse, T> g) {
        return obj -> g.apply((BatchAddRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private List<String> addedAccessorIds = DefaultSdkAutoConstructList.getInstance();
        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddRoleResponse model) {
            super(model);
            this.addedAccessorIds(model.addedAccessorIds);
            this.errors(model.errors);
        }

        public final Collection<String> getAddedAccessorIds() {
            if (this.addedAccessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addedAccessorIds;
        }

        public final void setAddedAccessorIds(Collection<String> addedAccessorIds) {
            this.addedAccessorIds = AccessorIdListCopier.copy(addedAccessorIds);
        }

        @Override
        public final Builder addedAccessorIds(Collection<String> addedAccessorIds) {
            this.addedAccessorIds = AccessorIdListCopier.copy(addedAccessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedAccessorIds(String ... addedAccessorIds) {
            this.addedAccessorIds(Arrays.asList(addedAccessorIds));
            return this;
        }

        public final List<BatchError.Builder> getErrors() {
            List<BatchError.Builder> result = BatchErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchError)((BatchError.Builder)BatchError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAddRoleResponse build() {
            return new BatchAddRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAddRoleResponse> {
        public Builder addedAccessorIds(Collection<String> var1);

        public Builder addedAccessorIds(String ... var1);

        public Builder errors(Collection<BatchError> var1);

        public Builder errors(BatchError ... var1);

        public Builder errors(Consumer<BatchError.Builder> ... var1);
    }
}

