/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProjectPoliciesCopier;
import software.amazon.awssdk.services.rekognition.model.ProjectPolicy;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProjectPoliciesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListProjectPoliciesResponse> {
    private static final SdkField<List<ProjectPolicy>> PROJECT_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectPolicies").getter(ListProjectPoliciesResponse.getter(ListProjectPoliciesResponse::projectPolicies)).setter(ListProjectPoliciesResponse.setter(Builder::projectPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProjectPoliciesResponse.getter(ListProjectPoliciesResponse::nextToken)).setter(ListProjectPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProjectPoliciesResponse.memberNameToFieldInitializer();
    private final List<ProjectPolicy> projectPolicies;
    private final String nextToken;

    private ListProjectPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.projectPolicies = builder.projectPolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProjectPolicies() {
        return this.projectPolicies != null && !(this.projectPolicies instanceof SdkAutoConstructList);
    }

    public final List<ProjectPolicy> projectPolicies() {
        return this.projectPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectPolicies() ? this.projectPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectPoliciesResponse)) {
            return false;
        }
        ListProjectPoliciesResponse other = (ListProjectPoliciesResponse)((Object)obj);
        return this.hasProjectPolicies() == other.hasProjectPolicies() && Objects.equals(this.projectPolicies(), other.projectPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProjectPoliciesResponse").add("ProjectPolicies", this.hasProjectPolicies() ? this.projectPolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectPolicies": {
                return Optional.ofNullable(clazz.cast(this.projectPolicies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProjectPolicies", PROJECT_POLICIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProjectPoliciesResponse, T> g) {
        return obj -> g.apply((ListProjectPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ProjectPolicy> projectPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectPoliciesResponse model) {
            super(model);
            this.projectPolicies(model.projectPolicies);
            this.nextToken(model.nextToken);
        }

        public final List<ProjectPolicy.Builder> getProjectPolicies() {
            List<ProjectPolicy.Builder> result = ProjectPoliciesCopier.copyToBuilder(this.projectPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectPolicies(Collection<ProjectPolicy.BuilderImpl> projectPolicies) {
            this.projectPolicies = ProjectPoliciesCopier.copyFromBuilder(projectPolicies);
        }

        @Override
        public final Builder projectPolicies(Collection<ProjectPolicy> projectPolicies) {
            this.projectPolicies = ProjectPoliciesCopier.copy(projectPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectPolicies(ProjectPolicy ... projectPolicies) {
            this.projectPolicies(Arrays.asList(projectPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectPolicies(Consumer<ProjectPolicy.Builder> ... projectPolicies) {
            this.projectPolicies(Stream.of(projectPolicies).map(c -> (ProjectPolicy)((ProjectPolicy.Builder)ProjectPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProjectPoliciesResponse build() {
            return new ListProjectPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProjectPoliciesResponse> {
        public Builder projectPolicies(Collection<ProjectPolicy> var1);

        public Builder projectPolicies(ProjectPolicy ... var1);

        public Builder projectPolicies(Consumer<ProjectPolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

