/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.RekognitionServiceClientConfiguration;
import software.amazon.awssdk.services.rekognition.internal.RekognitionServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest;
import software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ConflictException;
import software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.CreateUserRequest;
import software.amazon.awssdk.services.rekognition.model.CreateUserResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteUserRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteUserResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest;
import software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.services.rekognition.model.DetectTextResponse;
import software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetMediaAnalysisJobRequest;
import software.amazon.awssdk.services.rekognition.model.GetMediaAnalysisJobResponse;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.HumanLoopQuotaExceededException;
import software.amazon.awssdk.services.rekognition.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidManifestException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidPolicyRevisionIdException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.LimitExceededException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsRequest;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsResponse;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;
import software.amazon.awssdk.services.rekognition.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rekognition.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rekognition.model.ListUsersRequest;
import software.amazon.awssdk.services.rekognition.model.ListUsersResponse;
import software.amazon.awssdk.services.rekognition.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest;
import software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceInUseException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotReadyException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchUsersRequest;
import software.amazon.awssdk.services.rekognition.model.SearchUsersResponse;
import software.amazon.awssdk.services.rekognition.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.rekognition.model.SessionNotFoundException;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartMediaAnalysisJobRequest;
import software.amazon.awssdk.services.rekognition.model.StartMediaAnalysisJobResponse;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartTextDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.TagResourceRequest;
import software.amazon.awssdk.services.rekognition.model.TagResourceResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.model.UntagResourceRequest;
import software.amazon.awssdk.services.rekognition.model.UntagResourceResponse;
import software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.VideoTooLargeException;
import software.amazon.awssdk.services.rekognition.transform.AssociateFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CopyProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateFaceLivenessSessionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectPolicyRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectCustomLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectProtectiveEquipmentRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectTextRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DisassociateFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DistributeDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceLivenessSessionResultsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetMediaAnalysisJobRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetSegmentDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListDatasetLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListMediaAnalysisJobsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListProjectPoliciesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListStreamProcessorsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.PutProjectPolicyRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchUsersByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartMediaAnalysisJobRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartSegmentDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UpdateDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UpdateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.waiters.RekognitionWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRekognitionClient
implements RekognitionClient {
    private static final Logger log = Logger.loggerFor(DefaultRekognitionClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRekognitionClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Rekognition#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateFacesResponse associateFaces(AssociateFacesRequest associateFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, IdempotentParameterMismatchException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, associateFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFaces");
            AssociateFacesResponse associateFacesResponse = (AssociateFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$associateFaces$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompareFacesResponse compareFaces(CompareFacesRequest compareFacesRequest) throws InvalidParameterException, InvalidS3ObjectException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompareFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)compareFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, compareFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompareFaces");
            CompareFacesResponse compareFacesResponse = (CompareFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompareFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)compareFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CompareFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return compareFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$compareFaces$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyProjectVersionResponse copyProjectVersion(CopyProjectVersionRequest copyProjectVersionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, LimitExceededException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, ProvisionedThroughputExceededException, ResourceInUseException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyProjectVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyProjectVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, copyProjectVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyProjectVersion");
            CopyProjectVersionResponse copyProjectVersionResponse = (CopyProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyProjectVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copyProjectVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copyProjectVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$copyProjectVersion$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCollectionResponse createCollection(CreateCollectionRequest createCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCollectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCollectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCollection");
            CreateCollectionResponse createCollectionResponse = (CreateCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCollection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createCollection$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, LimitExceededException, InvalidS3ObjectException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            CreateDatasetResponse createDatasetResponse = (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createDataset$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFaceLivenessSessionResponse createFaceLivenessSession(CreateFaceLivenessSessionRequest createFaceLivenessSessionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFaceLivenessSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFaceLivenessSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createFaceLivenessSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFaceLivenessSession");
            CreateFaceLivenessSessionResponse createFaceLivenessSessionResponse = (CreateFaceLivenessSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFaceLivenessSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFaceLivenessSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFaceLivenessSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFaceLivenessSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createFaceLivenessSession$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ResourceInUseException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProject");
            CreateProjectResponse createProjectResponse = (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createProject$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectVersionResponse createProjectVersion(CreateProjectVersionRequest createProjectVersionRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProjectVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createProjectVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProjectVersion");
            CreateProjectVersionResponse createProjectVersionResponse = (CreateProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProjectVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createProjectVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProjectVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createProjectVersion$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStreamProcessorResponse createStreamProcessor(CreateStreamProcessorRequest createStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, LimitExceededException, ResourceInUseException, ProvisionedThroughputExceededException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamProcessor");
            CreateStreamProcessorResponse createStreamProcessorResponse = (CreateStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createStreamProcessor$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InvalidParameterException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, ProvisionedThroughputExceededException, IdempotentParameterMismatchException, AccessDeniedException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$createUser$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCollectionResponse deleteCollection(DeleteCollectionRequest deleteCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCollectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCollectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCollection");
            DeleteCollectionResponse deleteCollectionResponse = (DeleteCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCollection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteCollection$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            DeleteDatasetResponse deleteDatasetResponse = (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteDataset$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFacesResponse deleteFaces(DeleteFacesRequest deleteFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFaces");
            DeleteFacesResponse deleteFacesResponse = (DeleteFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteFaces$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ResourceInUseException, ResourceNotFoundException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProject");
            DeleteProjectResponse deleteProjectResponse = (DeleteProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteProject$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectPolicyResponse deleteProjectPolicy(DeleteProjectPolicyRequest deleteProjectPolicyRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPolicyRevisionIdException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProjectPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteProjectPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProjectPolicy");
            DeleteProjectPolicyResponse deleteProjectPolicyResponse = (DeleteProjectPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProjectPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProjectPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProjectPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProjectPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteProjectPolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectVersionResponse deleteProjectVersion(DeleteProjectVersionRequest deleteProjectVersionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProjectVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteProjectVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProjectVersion");
            DeleteProjectVersionResponse deleteProjectVersionResponse = (DeleteProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProjectVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProjectVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProjectVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteProjectVersion$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStreamProcessorResponse deleteStreamProcessor(DeleteStreamProcessorRequest deleteStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStreamProcessor");
            DeleteStreamProcessorResponse deleteStreamProcessorResponse = (DeleteStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteStreamProcessor$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidParameterException, ConflictException, ResourceNotFoundException, ProvisionedThroughputExceededException, IdempotentParameterMismatchException, AccessDeniedException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$deleteUser$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCollectionResponse describeCollection(DescribeCollectionRequest describeCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCollectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCollectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, describeCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCollection");
            DescribeCollectionResponse describeCollectionResponse = (DescribeCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCollection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$describeCollection$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            DescribeDatasetResponse describeDatasetResponse = (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$describeDataset$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProjectVersionsResponse describeProjectVersions(DescribeProjectVersionsRequest describeProjectVersionsRequest) throws ResourceNotFoundException, InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProjectVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeProjectVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, describeProjectVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeProjectVersions");
            DescribeProjectVersionsResponse describeProjectVersionsResponse = (DescribeProjectVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProjectVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeProjectVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeProjectVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeProjectVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$describeProjectVersions$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProjectsResponse describeProjects(DescribeProjectsRequest describeProjectsRequest) throws InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, describeProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeProjects");
            DescribeProjectsResponse describeProjectsResponse = (DescribeProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$describeProjects$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamProcessorResponse describeStreamProcessor(DescribeStreamProcessorRequest describeStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, describeStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStreamProcessor");
            DescribeStreamProcessorResponse describeStreamProcessorResponse = (DescribeStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$describeStreamProcessor$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectCustomLabelsResponse detectCustomLabels(DetectCustomLabelsRequest detectCustomLabelsRequest) throws ResourceNotFoundException, ResourceNotReadyException, InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, LimitExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectCustomLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectCustomLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectCustomLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectCustomLabels");
            DetectCustomLabelsResponse detectCustomLabelsResponse = (DetectCustomLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectCustomLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectCustomLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectCustomLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectCustomLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectCustomLabels$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectFacesResponse detectFaces(DetectFacesRequest detectFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectFaces");
            DetectFacesResponse detectFacesResponse = (DetectFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectFaces$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectLabelsResponse detectLabels(DetectLabelsRequest detectLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectLabels");
            DetectLabelsResponse detectLabelsResponse = (DetectLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectLabels$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectModerationLabelsResponse detectModerationLabels(DetectModerationLabelsRequest detectModerationLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, HumanLoopQuotaExceededException, ResourceNotFoundException, ResourceNotReadyException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectModerationLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectModerationLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectModerationLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectModerationLabels");
            DetectModerationLabelsResponse detectModerationLabelsResponse = (DetectModerationLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectModerationLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectModerationLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectModerationLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectModerationLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectModerationLabels$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectProtectiveEquipmentResponse detectProtectiveEquipment(DetectProtectiveEquipmentRequest detectProtectiveEquipmentRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectProtectiveEquipmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectProtectiveEquipmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectProtectiveEquipmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectProtectiveEquipment");
            DetectProtectiveEquipmentResponse detectProtectiveEquipmentResponse = (DetectProtectiveEquipmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectProtectiveEquipment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectProtectiveEquipmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectProtectiveEquipmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectProtectiveEquipmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectProtectiveEquipment$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectTextResponse detectText(DetectTextRequest detectTextRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectTextResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, detectTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectText");
            DetectTextResponse detectTextResponse = (DetectTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectText").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectTextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectTextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$detectText$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateFacesResponse disassociateFaces(DisassociateFacesRequest disassociateFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, IdempotentParameterMismatchException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, disassociateFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFaces");
            DisassociateFacesResponse disassociateFacesResponse = (DisassociateFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$disassociateFaces$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributeDatasetEntriesResponse distributeDatasetEntries(DistributeDatasetEntriesRequest distributeDatasetEntriesRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotReadyException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DistributeDatasetEntriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)distributeDatasetEntriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, distributeDatasetEntriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DistributeDatasetEntries");
            DistributeDatasetEntriesResponse distributeDatasetEntriesResponse = (DistributeDatasetEntriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DistributeDatasetEntries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)distributeDatasetEntriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DistributeDatasetEntriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return distributeDatasetEntriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$distributeDatasetEntries$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCelebrityInfoResponse getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCelebrityInfoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCelebrityInfoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getCelebrityInfoRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCelebrityInfo");
            GetCelebrityInfoResponse getCelebrityInfoResponse = (GetCelebrityInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCelebrityInfo").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCelebrityInfoRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCelebrityInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCelebrityInfoResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getCelebrityInfo$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCelebrityRecognitionResponse getCelebrityRecognition(GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCelebrityRecognitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCelebrityRecognitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getCelebrityRecognitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCelebrityRecognition");
            GetCelebrityRecognitionResponse getCelebrityRecognitionResponse = (GetCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCelebrityRecognition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCelebrityRecognitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCelebrityRecognitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCelebrityRecognitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getCelebrityRecognition$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContentModerationResponse getContentModeration(GetContentModerationRequest getContentModerationRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContentModerationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContentModerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getContentModerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContentModeration");
            GetContentModerationResponse getContentModerationResponse = (GetContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContentModeration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContentModerationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContentModerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContentModerationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getContentModeration$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFaceDetectionResponse getFaceDetection(GetFaceDetectionRequest getFaceDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFaceDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFaceDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getFaceDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFaceDetection");
            GetFaceDetectionResponse getFaceDetectionResponse = (GetFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFaceDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFaceDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFaceDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFaceDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getFaceDetection$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFaceLivenessSessionResultsResponse getFaceLivenessSessionResults(GetFaceLivenessSessionResultsRequest getFaceLivenessSessionResultsRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, SessionNotFoundException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFaceLivenessSessionResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFaceLivenessSessionResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getFaceLivenessSessionResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFaceLivenessSessionResults");
            GetFaceLivenessSessionResultsResponse getFaceLivenessSessionResultsResponse = (GetFaceLivenessSessionResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFaceLivenessSessionResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFaceLivenessSessionResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFaceLivenessSessionResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFaceLivenessSessionResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getFaceLivenessSessionResults$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFaceSearchResponse getFaceSearch(GetFaceSearchRequest getFaceSearchRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFaceSearchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFaceSearchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getFaceSearchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFaceSearch");
            GetFaceSearchResponse getFaceSearchResponse = (GetFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFaceSearch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFaceSearchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFaceSearchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFaceSearchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getFaceSearch$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLabelDetectionResponse getLabelDetection(GetLabelDetectionRequest getLabelDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLabelDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLabelDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getLabelDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLabelDetection");
            GetLabelDetectionResponse getLabelDetectionResponse = (GetLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLabelDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLabelDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLabelDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLabelDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getLabelDetection$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMediaAnalysisJobResponse getMediaAnalysisJob(GetMediaAnalysisJobRequest getMediaAnalysisJobRequest) throws AccessDeniedException, ResourceNotFoundException, InternalServerErrorException, InvalidParameterException, ProvisionedThroughputExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMediaAnalysisJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMediaAnalysisJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getMediaAnalysisJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMediaAnalysisJob");
            GetMediaAnalysisJobResponse getMediaAnalysisJobResponse = (GetMediaAnalysisJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMediaAnalysisJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMediaAnalysisJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMediaAnalysisJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMediaAnalysisJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getMediaAnalysisJob$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPersonTrackingResponse getPersonTracking(GetPersonTrackingRequest getPersonTrackingRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPersonTrackingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPersonTrackingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getPersonTrackingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPersonTracking");
            GetPersonTrackingResponse getPersonTrackingResponse = (GetPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPersonTracking").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPersonTrackingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPersonTrackingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPersonTrackingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getPersonTracking$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSegmentDetectionResponse getSegmentDetection(GetSegmentDetectionRequest getSegmentDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getSegmentDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegmentDetection");
            GetSegmentDetectionResponse getSegmentDetectionResponse = (GetSegmentDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegmentDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSegmentDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSegmentDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSegmentDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getSegmentDetection$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTextDetectionResponse getTextDetection(GetTextDetectionRequest getTextDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTextDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, getTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTextDetection");
            GetTextDetectionResponse getTextDetectionResponse = (GetTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTextDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$getTextDetection$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexFacesResponse indexFaces(IndexFacesRequest indexFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IndexFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)indexFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, indexFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IndexFaces");
            IndexFacesResponse indexFacesResponse = (IndexFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IndexFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)indexFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IndexFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return indexFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$indexFaces$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCollectionsResponse listCollections(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCollectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCollectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listCollectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCollections");
            ListCollectionsResponse listCollectionsResponse = (ListCollectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCollections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCollectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCollectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCollectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listCollections$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetEntriesResponse listDatasetEntries(ListDatasetEntriesRequest listDatasetEntriesRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, ResourceInUseException, ResourceNotFoundException, InvalidPaginationTokenException, ResourceNotReadyException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetEntriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetEntriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listDatasetEntriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetEntries");
            ListDatasetEntriesResponse listDatasetEntriesResponse = (ListDatasetEntriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetEntries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatasetEntriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetEntriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetEntriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listDatasetEntries$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetLabelsResponse listDatasetLabels(ListDatasetLabelsRequest listDatasetLabelsRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, ResourceInUseException, InvalidPaginationTokenException, ResourceNotFoundException, ResourceNotReadyException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listDatasetLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetLabels");
            ListDatasetLabelsResponse listDatasetLabelsResponse = (ListDatasetLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatasetLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listDatasetLabels$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFacesResponse listFaces(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFaces");
            ListFacesResponse listFacesResponse = (ListFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listFaces$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMediaAnalysisJobsResponse listMediaAnalysisJobs(ListMediaAnalysisJobsRequest listMediaAnalysisJobsRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMediaAnalysisJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMediaAnalysisJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listMediaAnalysisJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMediaAnalysisJobs");
            ListMediaAnalysisJobsResponse listMediaAnalysisJobsResponse = (ListMediaAnalysisJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMediaAnalysisJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMediaAnalysisJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMediaAnalysisJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMediaAnalysisJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listMediaAnalysisJobs$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectPoliciesResponse listProjectPolicies(ListProjectPoliciesRequest listProjectPoliciesRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProjectPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listProjectPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProjectPolicies");
            ListProjectPoliciesResponse listProjectPoliciesResponse = (ListProjectPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjectPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProjectPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProjectPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProjectPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listProjectPolicies$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamProcessorsResponse listStreamProcessors(ListStreamProcessorsRequest listStreamProcessorsRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamProcessorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStreamProcessorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listStreamProcessorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreamProcessors");
            ListStreamProcessorsResponse listStreamProcessorsResponse = (ListStreamProcessorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamProcessors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStreamProcessorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStreamProcessorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStreamProcessorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listStreamProcessors$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listTagsForResource$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$listUsers$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutProjectPolicyResponse putProjectPolicy(PutProjectPolicyRequest putProjectPolicyRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPolicyRevisionIdException, MalformedPolicyDocumentException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException, ServiceQuotaExceededException, ProvisionedThroughputExceededException, LimitExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutProjectPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putProjectPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, putProjectPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutProjectPolicy");
            PutProjectPolicyResponse putProjectPolicyResponse = (PutProjectPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutProjectPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putProjectPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutProjectPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putProjectPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$putProjectPolicy$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecognizeCelebritiesResponse recognizeCelebrities(RecognizeCelebritiesRequest recognizeCelebritiesRequest) throws InvalidS3ObjectException, InvalidParameterException, InvalidImageFormatException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RecognizeCelebritiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)recognizeCelebritiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, recognizeCelebritiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RecognizeCelebrities");
            RecognizeCelebritiesResponse recognizeCelebritiesResponse = (RecognizeCelebritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecognizeCelebrities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)recognizeCelebritiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RecognizeCelebritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return recognizeCelebritiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$recognizeCelebrities$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchFacesResponse searchFaces(SearchFacesRequest searchFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, searchFacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFaces");
            SearchFacesResponse searchFacesResponse = (SearchFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchFacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchFacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$searchFaces$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchFacesByImageResponse searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFacesByImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchFacesByImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, searchFacesByImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFacesByImage");
            SearchFacesByImageResponse searchFacesByImageResponse = (SearchFacesByImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFacesByImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchFacesByImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchFacesByImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchFacesByImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$searchFacesByImage$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws InvalidParameterException, ResourceNotFoundException, ProvisionedThroughputExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, searchUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchUsers");
            SearchUsersResponse searchUsersResponse = (SearchUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$searchUsers$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchUsersByImageResponse searchUsersByImage(SearchUsersByImageRequest searchUsersByImageRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidImageFormatException, InvalidS3ObjectException, ImageTooLargeException, ProvisionedThroughputExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchUsersByImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchUsersByImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, searchUsersByImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchUsersByImage");
            SearchUsersByImageResponse searchUsersByImageResponse = (SearchUsersByImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchUsersByImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchUsersByImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchUsersByImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchUsersByImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$searchUsersByImage$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCelebrityRecognitionResponse startCelebrityRecognition(StartCelebrityRecognitionRequest startCelebrityRecognitionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCelebrityRecognitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCelebrityRecognitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startCelebrityRecognitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCelebrityRecognition");
            StartCelebrityRecognitionResponse startCelebrityRecognitionResponse = (StartCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCelebrityRecognition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startCelebrityRecognitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCelebrityRecognitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCelebrityRecognitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startCelebrityRecognition$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartContentModerationResponse startContentModeration(StartContentModerationRequest startContentModerationRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartContentModerationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startContentModerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startContentModerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartContentModeration");
            StartContentModerationResponse startContentModerationResponse = (StartContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartContentModeration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startContentModerationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartContentModerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startContentModerationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startContentModeration$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFaceDetectionResponse startFaceDetection(StartFaceDetectionRequest startFaceDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFaceDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFaceDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startFaceDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFaceDetection");
            StartFaceDetectionResponse startFaceDetectionResponse = (StartFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFaceDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFaceDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFaceDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFaceDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startFaceDetection$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFaceSearchResponse startFaceSearch(StartFaceSearchRequest startFaceSearchRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFaceSearchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFaceSearchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startFaceSearchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFaceSearch");
            StartFaceSearchResponse startFaceSearchResponse = (StartFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFaceSearch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFaceSearchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFaceSearchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFaceSearchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startFaceSearch$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLabelDetectionResponse startLabelDetection(StartLabelDetectionRequest startLabelDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLabelDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startLabelDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startLabelDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLabelDetection");
            StartLabelDetectionResponse startLabelDetectionResponse = (StartLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLabelDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startLabelDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLabelDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLabelDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startLabelDetection$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMediaAnalysisJobResponse startMediaAnalysisJob(StartMediaAnalysisJobRequest startMediaAnalysisJobRequest) throws InternalServerErrorException, AccessDeniedException, InvalidParameterException, InvalidManifestException, InvalidS3ObjectException, ResourceNotFoundException, ResourceNotReadyException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMediaAnalysisJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMediaAnalysisJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startMediaAnalysisJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMediaAnalysisJob");
            StartMediaAnalysisJobResponse startMediaAnalysisJobResponse = (StartMediaAnalysisJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMediaAnalysisJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMediaAnalysisJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMediaAnalysisJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMediaAnalysisJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startMediaAnalysisJob$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPersonTrackingResponse startPersonTracking(StartPersonTrackingRequest startPersonTrackingRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPersonTrackingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPersonTrackingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startPersonTrackingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPersonTracking");
            StartPersonTrackingResponse startPersonTrackingResponse = (StartPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPersonTracking").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPersonTrackingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPersonTrackingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPersonTrackingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startPersonTracking$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartProjectVersionResponse startProjectVersion(StartProjectVersionRequest startProjectVersionRequest) throws ResourceNotFoundException, ResourceInUseException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartProjectVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startProjectVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startProjectVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartProjectVersion");
            StartProjectVersionResponse startProjectVersionResponse = (StartProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartProjectVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startProjectVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startProjectVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startProjectVersion$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSegmentDetectionResponse startSegmentDetection(StartSegmentDetectionRequest startSegmentDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSegmentDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSegmentDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startSegmentDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSegmentDetection");
            StartSegmentDetectionResponse startSegmentDetectionResponse = (StartSegmentDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSegmentDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSegmentDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSegmentDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSegmentDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startSegmentDetection$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartStreamProcessorResponse startStreamProcessor(StartStreamProcessorRequest startStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartStreamProcessor");
            StartStreamProcessorResponse startStreamProcessorResponse = (StartStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startStreamProcessor$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTextDetectionResponse startTextDetection(StartTextDetectionRequest startTextDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTextDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, startTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTextDetection");
            StartTextDetectionResponse startTextDetectionResponse = (StartTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTextDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$startTextDetection$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopProjectVersionResponse stopProjectVersion(StopProjectVersionRequest stopProjectVersionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopProjectVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopProjectVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, stopProjectVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopProjectVersion");
            StopProjectVersionResponse stopProjectVersionResponse = (StopProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopProjectVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopProjectVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopProjectVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$stopProjectVersion$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopStreamProcessorResponse stopStreamProcessor(StopStreamProcessorRequest stopStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, stopStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopStreamProcessor");
            StopStreamProcessorResponse stopStreamProcessorResponse = (StopStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$stopStreamProcessor$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, ServiceQuotaExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$tagResource$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$untagResource$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatasetEntriesResponse updateDatasetEntries(UpdateDatasetEntriesRequest updateDatasetEntriesRequest) throws InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidParameterException, AccessDeniedException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatasetEntriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDatasetEntriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, updateDatasetEntriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatasetEntries");
            UpdateDatasetEntriesResponse updateDatasetEntriesResponse = (UpdateDatasetEntriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatasetEntries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDatasetEntriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatasetEntriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatasetEntriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$updateDatasetEntries$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStreamProcessorResponse updateStreamProcessor(UpdateStreamProcessorRequest updateStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ProvisionedThroughputExceededException, ResourceInUseException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamProcessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidImageFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImageFormatException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "SessionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionNotFoundException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "VideoTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("VideoTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VideoTooLargeException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ImageTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTooLargeException::builder).build());
                }
                case "InvalidManifestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidManifestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidManifestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStreamProcessorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRekognitionClient.resolveMetricPublishers(clientConfiguration, updateStreamProcessorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStreamProcessor");
            UpdateStreamProcessorResponse updateStreamProcessorResponse = (UpdateStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamProcessor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateStreamProcessorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateStreamProcessorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRekognitionClient.lambda$updateStreamProcessor$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public RekognitionWaiter waiter() {
        return RekognitionWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "rekognition";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        RekognitionServiceClientConfigurationBuilder serviceConfigBuilder = new RekognitionServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RekognitionException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final RekognitionServiceClientConfiguration serviceClientConfiguration() {
        return new RekognitionServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateStreamProcessor$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatasetEntries$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopStreamProcessor$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopProjectVersion$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTextDetection$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startStreamProcessor$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSegmentDetection$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startProjectVersion$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPersonTracking$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMediaAnalysisJob$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLabelDetection$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFaceSearch$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFaceDetection$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startContentModeration$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCelebrityRecognition$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchUsersByImage$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchUsers$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFacesByImage$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFaces$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$recognizeCelebrities$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putProjectPolicy$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreamProcessors$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProjectPolicies$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMediaAnalysisJobs$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFaces$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetLabels$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetEntries$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCollections$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$indexFaces$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTextDetection$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegmentDetection$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPersonTracking$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMediaAnalysisJob$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLabelDetection$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFaceSearch$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFaceLivenessSessionResults$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFaceDetection$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContentModeration$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCelebrityRecognition$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCelebrityInfo$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$distributeDatasetEntries$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFaces$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectText$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectProtectiveEquipment$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectModerationLabels$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectLabels$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectFaces$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectCustomLabels$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStreamProcessor$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeProjects$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeProjectVersions$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCollection$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStreamProcessor$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProjectVersion$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProjectPolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProject$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFaces$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCollection$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStreamProcessor$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProjectVersion$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProject$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFaceLivenessSession$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCollection$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyProjectVersion$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$compareFaces$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFaces$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

