/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputConfig> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(OutputConfig.getter(OutputConfig::s3Bucket)).setter(OutputConfig.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(OutputConfig.getter(OutputConfig::s3KeyPrefix)).setter(OutputConfig.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final String s3KeyPrefix;

    private OutputConfig(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"OutputConfig").add("S3Bucket", (Object)this.s3Bucket()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3KeyPrefix", S3_KEY_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputConfig, T> g) {
        return obj -> g.apply((OutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConfig model) {
            this.s3Bucket(model.s3Bucket);
            this.s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public OutputConfig build() {
            return new OutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputConfig> {
        public Builder s3Bucket(String var1);

        public Builder s3KeyPrefix(String var1);
    }
}

