/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata;
import software.amazon.awssdk.services.rekognition.model.LabelDetection;
import software.amazon.awssdk.services.rekognition.model.LabelDetectionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLabelDetectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetLabelDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::jobStatusAsString)).setter(GetLabelDetectionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::statusMessage)).setter(GetLabelDetectionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoMetadata").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::videoMetadata)).setter(GetLabelDetectionResponse.setter(Builder::videoMetadata)).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::nextToken)).setter(GetLabelDetectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<LabelDetection>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::labels)).setter(GetLabelDetectionResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelModelVersion").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::labelModelVersion)).setter(GetLabelDetectionResponse.setter(Builder::labelModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::jobId)).setter(GetLabelDetectionResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<Video> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::video)).setter(GetLabelDetectionResponse.setter(Builder::video)).constructor(Video::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::jobTag)).setter(GetLabelDetectionResponse.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<GetLabelDetectionRequestMetadata> GET_REQUEST_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GetRequestMetadata").getter(GetLabelDetectionResponse.getter(GetLabelDetectionResponse::getRequestMetadata)).setter(GetLabelDetectionResponse.setter(Builder::getRequestMetadata)).constructor(GetLabelDetectionRequestMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetRequestMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, LABELS_FIELD, LABEL_MODEL_VERSION_FIELD, JOB_ID_FIELD, VIDEO_FIELD, JOB_TAG_FIELD, GET_REQUEST_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLabelDetectionResponse.memberNameToFieldInitializer();
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final String nextToken;
    private final List<LabelDetection> labels;
    private final String labelModelVersion;
    private final String jobId;
    private final Video video;
    private final String jobTag;
    private final GetLabelDetectionRequestMetadata getRequestMetadata;

    private GetLabelDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.labels = builder.labels;
        this.labelModelVersion = builder.labelModelVersion;
        this.jobId = builder.jobId;
        this.video = builder.video;
        this.jobTag = builder.jobTag;
        this.getRequestMetadata = builder.getRequestMetadata;
    }

    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<LabelDetection> labels() {
        return this.labels;
    }

    public final String labelModelVersion() {
        return this.labelModelVersion;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Video video() {
        return this.video;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public final GetLabelDetectionRequestMetadata getRequestMetadata() {
        return this.getRequestMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.labelModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.getRequestMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelDetectionResponse)) {
            return false;
        }
        GetLabelDetectionResponse other = (GetLabelDetectionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.labelModelVersion(), other.labelModelVersion()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.jobTag(), other.jobTag()) && Objects.equals(this.getRequestMetadata(), other.getRequestMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetLabelDetectionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("NextToken", (Object)this.nextToken()).add("Labels", this.hasLabels() ? this.labels() : null).add("LabelModelVersion", (Object)this.labelModelVersion()).add("JobId", (Object)this.jobId()).add("Video", (Object)this.video()).add("JobTag", (Object)this.jobTag()).add("GetRequestMetadata", (Object)this.getRequestMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "LabelModelVersion": {
                return Optional.ofNullable(clazz.cast(this.labelModelVersion()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "GetRequestMetadata": {
                return Optional.ofNullable(clazz.cast(this.getRequestMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("VideoMetadata", VIDEO_METADATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Labels", LABELS_FIELD);
        map.put("LabelModelVersion", LABEL_MODEL_VERSION_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("JobTag", JOB_TAG_FIELD);
        map.put("GetRequestMetadata", GET_REQUEST_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLabelDetectionResponse, T> g) {
        return obj -> g.apply((GetLabelDetectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private String nextToken;
        private List<LabelDetection> labels = DefaultSdkAutoConstructList.getInstance();
        private String labelModelVersion;
        private String jobId;
        private Video video;
        private String jobTag;
        private GetLabelDetectionRequestMetadata getRequestMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLabelDetectionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.nextToken(model.nextToken);
            this.labels(model.labels);
            this.labelModelVersion(model.labelModelVersion);
            this.jobId(model.jobId);
            this.video(model.video);
            this.jobTag(model.jobTag);
            this.getRequestMetadata(model.getRequestMetadata);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LabelDetection.Builder> getLabels() {
            List<LabelDetection.Builder> result = LabelDetectionsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<LabelDetection.BuilderImpl> labels) {
            this.labels = LabelDetectionsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<LabelDetection> labels) {
            this.labels = LabelDetectionsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(LabelDetection ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<LabelDetection.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (LabelDetection)((LabelDetection.Builder)LabelDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLabelModelVersion() {
            return this.labelModelVersion;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final GetLabelDetectionRequestMetadata.Builder getGetRequestMetadata() {
            return this.getRequestMetadata != null ? this.getRequestMetadata.toBuilder() : null;
        }

        public final void setGetRequestMetadata(GetLabelDetectionRequestMetadata.BuilderImpl getRequestMetadata) {
            this.getRequestMetadata = getRequestMetadata != null ? getRequestMetadata.build() : null;
        }

        @Override
        public final Builder getRequestMetadata(GetLabelDetectionRequestMetadata getRequestMetadata) {
            this.getRequestMetadata = getRequestMetadata;
            return this;
        }

        @Override
        public GetLabelDetectionResponse build() {
            return new GetLabelDetectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLabelDetectionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder nextToken(String var1);

        public Builder labels(Collection<LabelDetection> var1);

        public Builder labels(LabelDetection ... var1);

        public Builder labels(Consumer<LabelDetection.Builder> ... var1);

        public Builder labelModelVersion(String var1);

        public Builder jobId(String var1);

        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder jobTag(String var1);

        public Builder getRequestMetadata(GetLabelDetectionRequestMetadata var1);

        default public Builder getRequestMetadata(Consumer<GetLabelDetectionRequestMetadata.Builder> getRequestMetadata) {
            return this.getRequestMetadata((GetLabelDetectionRequestMetadata)((GetLabelDetectionRequestMetadata.Builder)GetLabelDetectionRequestMetadata.builder().applyMutation(getRequestMetadata)).build());
        }
    }
}

